<?php

namespace Test\AI;

use Game\Constant\GameConstantDefine;
use Game\Data\PvpPacket\PvpMsgData;
use Game\Logic\GenerateAiLogic;
use Game\Logic\Pvp\MatchAILogic;
use Test\TestBase;

class TestAI extends TestBase
{
    use GenerateAiLogic;
    use MatchAILogic;

    public function getPlayerId(): int
    {
        return 288918457353950857;
    }

    public function startTest()
    {
        //测试生成AI
        $ai = $this->generateAI(1,1, 10001, 0);
        var_dump($ai);
        print_r($ai->serializeToJsonString());

        //测试从DB查询
        $aiPlayersMessage = array();
        $this->getAIPlayerFromDB(1, 2, $aiPlayersMessage);
        var_dump($aiPlayersMessage);
        foreach ($aiPlayersMessage as $ai) {
            var_dump($ai->serializeToJsonString());
        }

        //测试根据比赛类型,补充AI
        $singlePlayerList[] = [
            PvpMsgData::PLAYER_ID => $this->getPlayerId(),
            PvpMsgData::GROUP_ID => 0,
            PvpMsgData::POSITION => 1
        ];
        $teamPlayerList[] = [
            PvpMsgData::PLAYER_ID => $this->getPlayerId(),
            PvpMsgData::GROUP_ID => 1,
            PvpMsgData::POSITION => 1
        ];
        echo "单人练习AI <br>";
        $aiPlayersMessage = $this->addMatchAI(GameConstantDefine::MATCH_MODE_SINGLE_PRACTISE, $singlePlayerList);
        foreach ($aiPlayersMessage as $ai) {
            var_dump($ai->serializeToJsonString());
        }
        echo "团队练习AI <br>";
        $aiPlayersMessage = $this->addMatchAI(GameConstantDefine::MATCH_MODE_TEAM_PRACTISE, $teamPlayerList);
        foreach ($aiPlayersMessage as $ai) {
            var_dump($ai->serializeToJsonString());
        }
        echo "单人排位AI <br>";
        $aiPlayersMessage = $this->addMatchAI(GameConstantDefine::MATCH_MODE_SINGLE_PAI_WEI, $singlePlayerList);
        foreach ($aiPlayersMessage as $ai) {
            var_dump($ai->serializeToJsonString());
        }
        echo "团队排位AI <br>";
        $aiPlayersMessage = $this->addMatchAI(GameConstantDefine::MATCH_MODE_TEAM_PAI_WEI, $teamPlayerList);
        foreach ($aiPlayersMessage as $ai) {
            var_dump($ai->serializeToJsonString());
        }
    }
}
