<?php

namespace Server;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Game\Config\GameConfig;
use Framework\Log\LogMark;
use Game\Constant\PacketDefineI;
use Server\Model\Service;
use Server\Config\ServerConfig;
use Throwable;

function catchException(Throwable $exception)
{
    $log = "catch exception";
    LogMark::getInstance()->markCritical(
        ErrorDefine::EXCEPTION_ERROR,
        $log,
        array("exception" => $exception->getMessage(), "code" => $exception->getCode(),
            "file" => $exception->getFile(), "line" => $exception->getLine(),
            "trace" => $exception->getTraceAsString())
    );
}

/**
 * @var Service $service
 */
$path = ServerConfig::MODEL_SERVICE[ServerConfig::SERVICE];
$service = new $path();
$service->init(GameConfig::getInstance()->GAME_SERVICE_ID(), Utils::getServerTimestamp());
$service->register();
$service->setControllerDefine(new PacketDefineI());
while (true) {
    try {
        $service->run();
    } catch (Throwable $exception) {
        catchException($exception);
    }
}
