<?php

/**
 * desc: 随机地图
 */

namespace Server\Model;
use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Framework\Logic\TemplateHelp;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplatePVPMap;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\TemplateDefine;

class RandMap implements IServerBase
{
    use PlayerDBHandler;
    use TemplateHelp;
    const MAP_RAND  = 'MapRand';  // 地图随机 json
    const MAP_DATE  = 'MapDate';  // 地图随机时间

    const MAP_LOW_START  = 1;
    const MAP_LOW_END    = 3;

    const MAP_LOW_GET    = 3;
    const MAP_HIGH_GET   = 2;

    const MAP_HIGH_START = 4;
    const MAP_HIGH_END   = 5;
    const MAP_NOT_RAND   = 2;

    public const RAND_MAP = 1;

    public function init(): bool
    {
        LogMark::getInstance()->markInfo("rand map init success!");
        return true;
    }

    public function close()
    {
        LogMark::getInstance()->markInfo("rand map close success!");
    }

    public function run($nowTime)
    {
        // 获取当前时间
        $date = date('Y-m-d');
        // 获取
        $ret = [];
        $this->searchTermMulti(
            $ret,
            DBTableDefine::TABLE_COMMON_CONST,
            0,
            0,
            [
                self::MAP_DATE,
            ]
        );
        $mapDate = $ret[self::MAP_DATE];

        if(empty($mapDate) || $date > $mapDate) {
            $mapList = $this->getRandMapList();
            $this->updateTitle(
                DBTableDefine::TABLE_COMMON_CONST,
                0,
                0,
                [
                    self::MAP_DATE => $date,
                    self::MAP_RAND => json_encode($mapList),
                ]
            );
        }
//        $this->close();
    }

    private function getRandMapList(): array {
        $mapIDS = [];
        $maps = $this->getTable(TemplateDefine::TYPE_PVP_MAP);
        foreach($maps as $id => $item) {
            if($item[TemplatePVPMap::OpenIf] === 'True' && $item[TemplatePVPMap::Id] != self::RAND_MAP) {
                $mapIDS[] = (int)$item[TemplatePVPMap::Id];
            }
        }
        return $mapIDS;
        $mapNew = [];
        $mapLow = [];
        $mapHigh = [];
        // 获取所有地图
        foreach($maps as $id => $mapCfg) {
            if(is_null($mapCfg)) {
                break;
            }
            LogMark::getInstance()->markInfo("rand map init success!", [$mapCfg[TemplatePVPMap::Id]]);
            if($mapCfg[TemplatePVPMap::Random] == self::MAP_NOT_RAND) {
                $mapNew[] = (int)$mapCfg[TemplatePVPMap::Id];
                continue;
            }
            if($mapCfg[TemplatePVPMap::Level] >= self::MAP_LOW_START &&
                $mapCfg[TemplatePVPMap::Level] <= self::MAP_LOW_END) {
                $mapLow[] = (int)$mapCfg[TemplatePVPMap::Id];
                continue;
            }
            $mapHigh[] = (int)$mapCfg[TemplatePVPMap::Id];
        }

        $arr = [];
        $low = array_rand($mapLow, self::MAP_LOW_GET);
        foreach($low as $k) {
            $arr[] = $mapLow[$k];
        }
        if(!empty($mapHigh)) {
            $high = array_rand($mapHigh, self::MAP_HIGH_GET);
            foreach($high as $k) {
                $arr[] = $mapHigh[$k];
            }
        }
        $len = count($mapNew);

        if(empty($len)) {
            return array_values($arr);
        }

        if($len <= 2) {
            foreach($mapNew as $k) {
                $arr[] = $k;
            }
        } else {
            $new  = array_rand($mapNew, $len);
            foreach($new as $k) {
                $arr[] = $mapHigh[$k];
            }
        }
        return array_values($arr);
    }
}
