<?php
/**
 * 玩家离线处理
 * @date 2022-4-27
 * @author JZW
 **/
namespace Server\Model\Player;

use Framework\Model\OnLineModel;
use Game\Constant\GameConstantDefine;
use Game\Logic\AccountLogic;
use Server\Model\IServerBase;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Logic\OnLineLogic;
use Game\Constant\ModelTypeDefine;

class OffLine implements IServerBase
{
    use OnLineLogic;
    use AccountLogic;

    public function init(): bool
    {
        LogMark::getInstance()->markInfo("offline init success!");
        return true;
    }

    public function close()
    {
    }

    public function run($nowTime)
    {
        if (!$this->getOffLinePlayerId($ret)){
            return false;
        }
        //ret=[playerId=>上次同步在线时间]
        if (is_array($ret) && count($ret) > 0){
            foreach ($ret as $playerId => $time){
                if ($this->checkOnePlayerOnLine($playerId, $time)){
                    continue;
                }

                ModelManager::getInstance()->setPlayerId($playerId);
                if (!$this->updateTimeById($playerId, OnLineModel::OffLineDefaultTime)){
                    continue;
                }
                $this->setPlayerOffline($playerId, $time);
                $this->ClearPlayerData();
            }
        }
        return true;
    }

    private function ClearPlayerData()
    {
        //暂时没有对应方法和需求 注释掉
//        foreach (ModelTypeDefine::MODEL_MAP as $modelType => $value) {
//            $model = ModelManager::getInstance()->getModel($modelType);
//            if (!is_null($model) && method_exists($model, "onClear")) {
//                $model->onClear();
//            }
//        }
        ModelManager::getInstance()->clearModelList();
    }
}