<?php
/**
 * 房间检测，如果房间内玩家是离线，则帮助玩家退出房间
 * @date 2023-01-03
 * @author leeFx
 **/
namespace Server\Model\Player;

use Framework\Lib\Utils;
use Game\Constant\DBTableDefine;
use Game\Data\RoomData;
use Server\Model\IServerBase;
use Framework\Log\LogMark;
use Game\Constant\GameErrorCode;
use Game\Data\RoomCustomizeData;
use Game\Logic\RoomCustomize\RoomLogic;
class CheckCustomizeRoom implements IServerBase
{
    use RoomLogic;

    public function init(): bool
    {
        LogMark::getInstance()->markInfo("check time out customize room init success!");
        return true;
    }

    public function close()
    {
        // TODO: Implement close() method.
    }

    public function run($nowTime)
    {
        if (!$this->cliGetTimeOutRoomList($ret)){
            return false;
        }
        if (is_array($ret) && count($ret) > 0){
            $nowTime = Utils::getServerTimestamp();
            foreach ($ret as $roomID => $time){
                if ($time < $nowTime){
                    // 获取room内玩家信息
                    $room = $this->cliGetRoomInfoByRoomID($roomID);
                    if(is_null($room)) {
                        if(!$this->delRank(DBTableDefine::TABLE_ROOM_CUSTOMIZE_TIME, 0, $roomID)) {
                            LogMark::getInstance()->markError(GameErrorCode::DATA_DELETE_ERROR,
                                'customize room not found del timer error!');
                        }
                        if(!$this->delRank(DBTableDefine::TABLE_ROOM_CUSTOMIZE, 0, $roomID)) {
                            LogMark::getInstance()->markError(GameErrorCode::DATA_DELETE_ERROR,
                                'customize room not found del room list error!');
                        }
                        continue;
                    }
                    $players = $room->playerInfo;
                    if(empty($players)) {
                        // 删除房间时间
                        if(!$this->delRank(DBTableDefine::TABLE_ROOM_CUSTOMIZE_TIME, 0, $roomID)) {
                            LogMark::getInstance()->markError(GameErrorCode::DATA_DELETE_ERROR,
                            'customize room players is empty del timer error!');
                        }
                        // 删除房间列表
                        if(!$this->delRank(DBTableDefine::TABLE_ROOM_CUSTOMIZE, 0, $roomID)) {
                            LogMark::getInstance()->markError(GameErrorCode::DATA_DELETE_ERROR,
                                'customize room players is empty del room list error!');
                        }
                        $roomField = array_merge(array_keys(RoomCustomizeData::DB_CUSTOMIZE_MAP),
                            array_keys(RoomData::DB_KEY_MAP));
                        // 删除房间信息
                        if(!$this->delHDelTermMulti(DBTableDefine::TABLE_ROOM_CUSTOMIZE, 0,
                            $roomID, $roomField)) {
                            LogMark::getInstance()->markError(GameErrorCode::DATA_DELETE_ERROR,
                                'customize room players is empty del room error!');
                        }
                        continue;
                    }

                    if(!$this->RemoveRoomAllPlayer($roomID)) {
                        LogMark::getInstance()->markError(
                            GameErrorCode::DATA_DELETE_ERROR,
                            '[cli check customize] clear room error!',
                            ['roomID' => $roomID]
                        );
                        return false;
                    }

//                    foreach ($players as $playerID => $data) {
//
//                        if($data[RoomCustomizeData::ROLE] != RoomCustomizeModel::IN_ROOM) {
//                            continue;
//                        }
////                        // 检测玩家在线状态
////                        if ($this->getRoleStatus($playerID) != RoleExtData::OffLine){
////                            continue;
////                        }
//                        // 离线则退出房间操作
//                        LogMark::getInstance()->markInfo("offline exit customize room exec!");
//                        if(!$this->cliCheckOffLineExitRoom($roomID, $playerID)) {
//                            LogMark::getInstance()->markError(
//                                GameErrorCode::DATA_DELETE_ERROR,
//                                '[roomModel] cli check exit customize room error!',
//                                ['roomID' => $roomID, 'playerID' => $playerID]
//                            );
//                            return false;
//                        }
//                    }
                }
            }
        }
        return true;
    }
}