<?php

/**
 * 全局定时器
 */

namespace Server\Model\CommonTimer;

use Server\Model\IServerBase;
use Framework\Log\LogMark;
use Framework\Logic\CommonTimerLogic;

class Timer implements IServerBase
{
    use CommonTimerLogic;

    public function init(): bool
    {
        LogMark::getInstance()->markInfo("CommonTimer init Success");
        return true;
    }

    public function close()
    {
        LogMark::getInstance()->markInfo("CommonTimer close Success");
    }

    public function run($nowTime)
    {
        $this->commonTimerHeartBeat($nowTime);
    }
}
