<?php

/**
 * CLIServer.php
 * 文件描述
 * Created On 2022/4/25
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Server;


use Framework\Lib\Utils;
use Game\Config\GameConfig;
use Framework\Log\LogMark;

use Framework\Define\ErrorDefine;
use Throwable;

if (ServerManager::getInstance()->init() != ErrorDefine::SUCCESS) {
    exit();
}

function catchException(Throwable $exception)
{
    $log = "catch exception";
    LogMark::getInstance()->markCritical(
        ErrorDefine::EXCEPTION_ERROR,
        $log,
        array("exception" => $exception->getMessage(), "code" => $exception->getCode(),
            "file" => $exception->getFile(), "line" => $exception->getLine(),
            "trace" => $exception->getTraceAsString())
    );
}

pcntl_signal(SIGQUIT, function ($signalNo) {
    ServerManager::getInstance()->close();
    exit;
});

while (true) {
    pcntl_signal_dispatch();
    try {
        ServerManager::getInstance()->run(Utils::getServerTimestamp());
    } catch (Throwable $exception) {
        catchException($exception);
    }
    sleep(GameConfig::getInstance()->CLI_SERVER_SLEEP());
}
