<?php

/**
 * 文件描述，这是一个范例描述文档的规范
 * 文件中只能有一个外部类
 * Created On 2021/12/1
 * @author yuanb yuanbo0x@gmail.com
 */

/**
 * 需要按照目录设定命名空间
 */

namespace Library;

/**
 * 描述类的作用，范例描述
 * 类名必须和文件名一致
 */
class StandardExample
{
    /**
     * @var int $test_int 成员变量范例
     */
    private int $test_int;

    /**
     * @var string VERSION_STRING 常量成员范例
     */
    public const VERSION_STRING = "1.0.1";

    /**
     * @var string $s_test_static 静态成员变量范例
     */
    public static string $s_test_static;

    /**
     * 描述静态方法的用途
     * @param $test_a
     * @return string
     */
    public static function testStatic($test_a): string
    {
        self::$s_test_static = $test_a;
        return "ok";
    }

    /**
     * 描述一般方法的用途
     * @param $test_b
     * @return int
     */
    public function testVal($test_b): int
    {
        $this->test_int = $test_b * 10;
        return 1;
    }

    /**
     * 描述获取版本
     * @return string
     */
    public function getVersion(): string
    {
        return self::VERSION_STRING;
    }

    /**
     * 描述一般获取方法
     * @return int
     */
    public function getVal(): int
    {
        return $this->test_int;
    }
}
