<?php


namespace Library\DB;


interface IRedis
{
    public function createRedis(array $info): bool;

    public function startPipe();

    public function finishPipe();

    public function getLastError(): string;

    public function ExistError(): bool;

    public function isPipe(): bool;

    public function evalSha(&$ret, string $sha, array $param, int $key_num): bool;

    public function hIncrBy(&$ret, array $param): bool;

    public function exists(&$ret, array $param): bool;

    public function script(&$ret, array $param): bool;

    public function del(&$ret, array $param): bool;

    public function keys(&$ret, array $param): bool;

    public function set(&$ret, array $param): bool;

    public function get(&$ret, array $param): bool;

    public function hExists(&$ret, array $param): bool;

    public function hGet(&$ret, array $param): bool;

    public function hMSet(&$ret, array $param): bool;

    public function hMGet(&$ret, array $param): bool;

    public function expire(&$ret, array $param): bool;

    public function hDel(&$ret, array $param): bool;

    public function hGetAll(&$ret, array $param): bool;

    public function hLen(&$ret, array $param): bool;

    public function zScore(&$ret, array $param): bool;

    public function BRPop(&$ret, array $param): bool;

    public function zRange(&$ret, array $param): bool;

    public function zRevRange(&$ret, array $param): bool;

    public function zRangeByScore(&$ret, array $param): bool;

    public function zRevRangeByScore(&$ret, array $param): bool;

    public function zRemRangeByScore(&$ret, array $param): bool;

    public function zAdd(&$ret, array $param): bool;

    public function sAdd(&$ret, array $param): bool;

    public function sRem(&$ret, array $param): bool;

    public function zRem(&$ret, array $param): bool;

    public function rPush(&$ret, array $param): bool;

    public function lRange(&$ret, array $param): bool;

    public function lTrim(&$ret, array $param): bool;

    public function lPop(&$ret, array $param): bool;

    public function BLPop(&$ret, array $param): bool;

    public function lRem(&$ret, array $param): bool;

    public function zCard(&$ret, array $param): bool;

    public function sRandMember(&$ret, array $param): bool;

    public function sCard(&$ret, array $param): bool;

    public function sMembers(&$ret, array $param): bool;
}