<?php

/**
 * 定义通用常量类
 * Created On 2021/11/1
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Library\Common;

/**
 * 单例组件
 */
trait Singletons
{
    private function __construct()
    {
    }

    private function __clone()
    {
    }

    private static self $instance;

    /**
     * 获取类的静态对象
     * @return self 本类静态对象
     */
    public static function getInstance(): self
    {
        if (!isset(self::$instance)) {
            self::$instance = new static();
            //这里不能new self(),self和static区别
        }
        return self::$instance;
    }
}
