<?php
/**
 * @author neeke@php.net
 * Date: 14-1-27 16:47
 */
define('SEASLOG_ALL', 'ALL');
define('SEASLOG_DEBUG', 'DEBUG');
define('SEASLOG_INFO', 'INFO');
define('SEASLOG_NOTICE', 'NOTICE');
define('SEASLOG_WARNING', 'WARNING');
define('SEASLOG_ERROR', 'ERROR');
define('SEASLOG_CRITICAL', 'CRITICAL');
define('SEASLOG_ALERT', 'ALERT');
define('SEASLOG_EMERGENCY', 'EMERGENCY');
define('SEASLOG_DETAIL_ORDER_ASC', 1);
define('SEASLOG_DETAIL_ORDER_DESC', 2);
define('SEASLOG_CLOSE_LOGGER_STREAM_MOD_ALL', 1);
define('SEASLOG_CLOSE_LOGGER_STREAM_MOD_ASSIGN', 2);
define('SEASLOG_REQUEST_VARIABLE_DOMAIN_PORT', 1);
define('SEASLOG_REQUEST_VARIABLE_REQUEST_URI', 2);
define('SEASLOG_REQUEST_VARIABLE_REQUEST_METHOD', 3);
define('SEASLOG_REQUEST_VARIABLE_CLIENT_IP', 4);

class SeasLog
{
    public function __construct()
    {
        #SeasLog init
    }

    public function __destruct()
    {
        #SeasLog distroy
    }

    /**
     * Set The basePath
     *
     * @param $basePath
     *
     * @return bool
     */
    static public function setBasePath($basePath)
    {
        return TRUE;
    }

    /**
     * Get The basePath
     *
     * @return string
     */
    static public function getBasePath()
    {
        return 'the base_path';
    }
    
    /**
     * Set The requestID
     * @param string
     * @return bool
     */
    static public function setRequestID($request_id){
        return TRUE;
    }
    /**
     * Get The requestID
     * @return string
     */
    static public function getRequestID(){
        return uniqid();
    }

    /**
     * Set The logger
     * @param $module
     *
     * @return bool
     */
    static public function setLogger($module)
    {
        return TRUE;
    }
    
    /**
     * Manually release stream flow from logger
     *
     * @param $model
     * @param $logger
     *
     * @return bool
     */
    static public function closeLoggerStream($model = SEASLOG_CLOSE_LOGGER_STREAM_MOD_ALL, $logger)
    {
        return true;
    }

    /**
     * Get The lastest logger
     * @return string
     */
    static public function getLastLogger()
    {
        return 'the lastLogger';
    }

    /**
     * Set The DatetimeFormat
     * @param $format
     *
     * @return bool
     */
    static public function setDatetimeFormat($format)
    {
        return TRUE;
    }

    /**
     * Get The DatetimeFormat
     * @return string
     */
    static public function getDatetimeFormat()
    {
        return 'the datetimeFormat';
    }

    /**
     * Set Reqeust Variable
     *
     * @param $key
     * @param $value
     *
     * @return bool
     */
    static public function setRequestVariable($key, $value)
    {
        return true;
    }

    /**
     * Get Reqeust Variable
     *
     * @param $key
     *
     * @return string
     */
    static public function getRequestVariable($key)
    {
        return '';
    }
    
    /**
     * Count All Types（Or Type）Log Lines
     * @param string $level
     * @param string $log_path
     * @param null   $key_word
     *
     * @return array | long
     */
    static public function analyzerCount($level = 'all', $log_path = '*', $key_word = NULL)
    {
        return array();
    }

    /**
     * Get The Logs As Array
     *
     * @param        $level
     * @param string $log_path
     * @param null   $key_word
     * @param int    $start
     * @param int    $limit
     * @param        $order SEASLOG_DETAIL_ORDER_ASC(Default)  SEASLOG_DETAIL_ORDER_DESC
     *
     * @return array
     */
    static public function analyzerDetail($level = SEASLOG_INFO, $log_path = '*', $key_word = NULL, $start = 1, $limit = 20, $order = SEASLOG_DETAIL_ORDER_ASC)
    {
        return array();
    }

    /**
     * Get The Buffer In Memory As Array
     *
     * @return array
     */
    static public function getBuffer()
    {
        return array();
    }

    /**
     * Get The Buffer Enabled Or Not
     *
     * @return bool
     */
    static public function getBufferEnabled()
    {
        return true;
    }
    
    /**
    * Get The Buffer Count
    *
    * @return int
    */
    static public function getBufferCount()
    {
        return 0;
    }

    /**
     * Flush The Buffer Dump To Writer Appender
     *
     * @return bool
     */
    static public function flushBuffer()
    {
        return TRUE;
    }

    /**
     * Record Debug Log
     *
     * @param string|array $message
     * @param array        $context
     * @param string       $module
     */
    static public function debug($message, array $context = array(), $module = '')
    {
        #$level = SEASLOG_DEBUG
    }

    /**
     * Record Info Log
     *
     * @param string|array $message
     * @param array        $context
     * @param string       $module
     */
    static public function info($message, array $context = array(), $module = '')
    {
        #$level = SEASLOG_INFO
    }

    /**
     * Record Notice Log
     *
     * @param string|array $message
     * @param array        $context
     * @param string       $module
     */
    static public function notice($message, array $context = array(), $module = '')
    {
        #$level = SEASLOG_NOTICE
    }

    /**
     * Record Warning Log
     *
     * @param string|array $message
     * @param array        $context
     * @param string       $module
     */
    static public function warning($message, array $context = array(), $module = '')
    {
        #$level = SEASLOG_WARNING
    }

    /**
     * Record Error Log
     *
     * @param string|array $message
     * @param array        $context
     * @param string       $module
     */
    static public function error($message, array $context = array(), $module = '')
    {
        #$level = SEASLOG_ERROR
    }

    /**
     * Record Critical Log
     *
     * @param string|array $message
     * @param array        $context
     * @param string       $module
     */
    static public function critical($message, array $context = array(), $module = '')
    {
        #$level = SEASLOG_CRITICAL
    }

    /**
     * Record Alert Log
     *
     * @param string|array $message
     * @param array        $context
     * @param string       $module
     */
    static public function alert($message, array $context = array(), $module = '')
    {
        #$level = SEASLOG_ALERT
    }

    /**
     * Record Emergency Log
     *
     * @param string|array $message
     * @param array        $context
     * @param string       $module
     */
    static public function emergency($message, array $context = array(), $module = '')
    {
        #$level = SEASLOG_EMERGENCY
    }

    /**
     * The Common Record Log Function
     * @param              $level
     * @param string|array $message
     * @param array        $context
     * @param string       $module
     */
    static public function log($level, $message, array $context = array(), $module = '')
    {

    }
}
