<?php
/**
 * @date 2022-06-10
 * @auther lee-fx
 * @desc gm 入口文件
 */

// 放开访问权限
header("content-type:text/html;charset=utf-8");
header('Access-Control-Allow-Origin:*');
header("Access-Control-Allow-Headers:Origin,X-Requested-With,Content-Type,Accept,x-file-name, Token");
header("Access-Control-Allow-Methods:GET, POST, PUT, DELETE");
date_default_timezone_set('Asia/Shanghai');

getLoad();

use Framework\Log\LogMark;
use Gm\Lib\Jwt;
use Gm\Config\ClassMapDef;
use Gm\Config\Config;
use Gm\Config\ErrorCode;

$uri = $_SERVER['REQUEST_URI'];

$urlArr = explode('/', $uri);
$url = '/'.$urlArr[2].'/'.$urlArr[3];

// 路由白名单
$router_write = [
    '/User/Login'
];

// JWT鉴权
if(!in_array($url, $router_write)) {
    $user = Jwt::verifyToken();
    if (!$user) {
        $res = [
            'code' => ErrorCode::ERROR_TOKEN_IS_FAILED,
            'message' => '鉴权失败',
        ];
        echo json_encode($res);
        exit;
    }

    if(!Jwt::verifyUserIsRepeat()) {
        $res = [
            'code' => ErrorCode::ERROR_USER_REPEAT,
            'message' => '账号不同设备登录！',
        ];
        echo json_encode($res);
        exit;
    }
}

// 查看是否有此路由权限
// 请求的路由   menu菜单id
$url_arr = explode('/', $url);
$class = $url_arr[1];

if (strpos($url_arr[2], '?')) {
    $method = explode('?', $url_arr[2])[0];
} else if (strpos($url_arr[2], '&')) {
    $method = explode('&', $url_arr[2])[0];
} else {
    $method = $url_arr[2];
}

/*
 * 引入类文件，自动加载
 */
function getLoad() {
    spl_autoload_register(
        function ($className) {
            $root = __DIR__;
            $root = dirname($root);
            $className = str_replace("\\", "/", $className);
            $file = $root . DIRECTORY_SEPARATOR . $className. '.php';
            if(is_file($file)) {
                require_once $file;
            }
        }
    );
}

// 开启sessionID
session_start();

// 配置加载
LogMark::getInstance()->init(Config::LOG_PATH);

$classObj = (new ClassMapDef())->getClassObj($class);

$classObj->$method();






