# 项目说明
  简版mvc框架，配合前端实现后端接口部分

### IDE

- phpstorm


### 项目结构
- CLI  ------------------ 执行监听脚本
- Comm ------------------ 复用函数文件
- Config ---------------- 配置文件
- Controller ------------ 控制层 | 路由入口
- Core ------------------ 核心文件
- Lib ------------------- 依赖文件
- Model ----------------- 模型层
- Test ------------------ 测试文件
- README ---------------- 说明文件
- index.php ------------- 入口文件


----------------------


#### 备份
- /Test/db_back   // 数据库备份文件

#### nginx 配置

``` text
server {
        listen       81;
        server_name zone2.ng.com;
        location / {
            root  "/data/web/game/Gm/dist";
            index insex.html index.htm;
        }


        location ~ \.php(.*)$  {
            root "/data/web/game/Gm";
            fastcgi_pass   unix:/dev/shm/php-cgi.sock;
            fastcgi_index  index.php;
            fastcgi_split_path_info  ^((?U).+\.php)(/?.+)$;
            fastcgi_param  SCRIPT_FILENAME  $document_root$fastcgi_script_name;
            fastcgi_param  PATH_INFO  $fastcgi_path_info;
            fastcgi_param  PATH_TRANSLATED  $document_root$fastcgi_path_info;
            include        fastcgi_params;
        }
}
```

