<?php
namespace Gm\Model;
use Gm\Core\MysqlLib;
class Xhprofs {
    // 获取总条数
    public static function GetCount($db_tab,$option) {
        $db = MysqlLib::GetInstance(['dbname'=>'game-tools']);
        // 总条数
        $where = [];
        $sql = "select count(*) as total from $db_tab";
        if ($option != ''){
            $arr = explode(',', $option);
            $sql .= ' where ';
            foreach($arr as $k) {
                if(strpos($k, '>=') !== false) {
                    $t = explode('>=', $k);
                    $sql .= $t[0] . ">=" .$t[1] . " and ";
                }else if(strpos($k, '<=') !== false) {
                    $t = explode('<=', $k);
                    $sql .= $t[0] . "<=" .$t[1] . " and ";
                }else if(strpos($k, '!=') !== false) {
                    $t = explode('!=', $k);
                    $sql .= $t[0] . "!='" .$t[1] . "'". " and ";
                }else if(strpos($k, '>') !== false) {
                    $t = explode('>', $k);
                    $sql .= $t[0] . ">" .$t[1] . " and ";
                }else if(strpos($k, '<') !== false) {
                    $t = explode('<', $k);
                    $sql .= $t[0] . "<" .$t[1] . " and ";
                }else if(strpos($k, '=') !== false) {
                    $t = explode('=', $k);
                    $sql .= $t[0] . "='" .$t[1] . "'". " and ";
                }
            }

            $sql = substr($sql, 0, strrpos($sql, 'and'));
        }
        return $db->link->query($sql)->fetchColumn();
    }

    // 获取数据
    public static function GetInfo($db_tab,$option, $pageSize, $pageBegin) {
        $sql = "select * from $db_tab ";
        if ($option != ''){
            $arr = explode(',', $option);
            $sql .= ' where ';
            foreach($arr as $k) {
                if(strpos($k, '>=') !== false) {
                    $t = explode('>=', $k);
                    $sql .= $t[0] . ">=" .$t[1] . " and ";
                }else if(strpos($k, '<=') !== false) {
                    $t = explode('<=', $k);
                    $sql .= $t[0] . "<=" .$t[1] . " and ";
                }else if(strpos($k, '!=') !== false) {
                    $t = explode('!=', $k);
                    $sql .= $t[0] . "!='" .$t[1] . "'". " and ";
                }else if(strpos($k, '>') !== false) {
                    $t = explode('>', $k);
                    $sql .= $t[0] . ">" .$t[1] . " and ";
                }else if(strpos($k, '<') !== false) {
                    $t = explode('<', $k);
                    $sql .= $t[0] . "<" .$t[1] . " and ";
                }else if(strpos($k, '=') !== false) {
                    $t = explode('=', $k);
                    $sql .= $t[0] . "='" .$t[1] . "'". " and ";
                } else {
                    return false;
                }
            }

            $sql = substr($sql, 0, strrpos($sql, 'and'));
        }


        $sql .= " order by unix desc";
        $sql .= " limit " . $pageBegin . "," . $pageSize . ";";

//        echo $sql;

        $db = MysqlLib::GetInstance(['dbname'=>'game-tools']);
        $data = $db->link->query($sql)->fetchAll();
        return $data;
    }

    // 获取总条数
    public static function GetSetCount($name) {
        $db = MysqlLib::GetInstance(['dbname'=>'game-tools']);
        // 总条数
        if ($name != ''){
            return $db->link->count('xhprof_set', '*', ['name' => $name]);
        } else {
            return $db->link->count('xhprof_set', '*');
        }
    }

    // 获取数据
    public static function GetSetInfo($name, $pageSize, $pageBegin, $uid) {
        $db = MysqlLib::GetInstance(['dbname'=>'game-tools']);
        $where = [];
        if ($name != ''){
            return $db->link->select('xhprof_set', '*', [
                'name' => $name,
                'uid' => $uid,
                'ORDER' => ['id' => 'DESC'],
                'LIMIT' => [$pageBegin, $pageSize],
            ]);
        } else {
            return $db->link->select('xhprof_set', '*', [
                'uid' => $uid,
                'ORDER' => ['id' => 'DESC'],
                'LIMIT' => [$pageBegin, $pageSize],
            ]);
        }
    }

    public static function GetXhprofSetInfoByName($name) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('xhprof_set', '*', [
            'name' => $name
        ]);
    }

    // 增加配置
    public static function AddXhprofSet($name, $ip, $db_tab, $uid) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->insert('xhprof_set', [
            'name' => $name,
            'ip' => $ip,
            'db_tab' => $db_tab,
            'uid' => $uid,
        ]);
    }

    // 修改配置
    public static function UpdateXhprofSet($id, $name, $ip, $db_tab) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->update('xhprof_set', [
            'name' => $name,
            'ip' => $ip,
            'db_tab' => $db_tab
        ], ['id' => $id]);
    }

    // 通过id获取配置信息
    public static function GetXhprofSetById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('xhprof_set', '*', ['id' => $id])[0];
    }

    // 删除配置信息
    public static function DeleteXhporfSetById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->delete('xhprof_set', [
            'id' => $id
        ]);
    }

    // 获取所有数据库分析表
    public static function GetAllXhprofTab() {
        $db = MysqlLib::GetInstance(['dbname'=>'game-tools']);
        return $db->link->select('xhprof_set', '*',[
            'ORDER' => ['id' => 'DESC']
        ]);
    }

    // 数据库表是否存在
    public static function DbTableIsHave($tbl) {
        $sql = "show tables like "."'". $tbl."'";
        $db = MysqlLib::GetInstance(['dbname'=>'game-tools']);
        return $db->link->query($sql)->fetchAll();
    }

    // 数据库表是否存在 不存在则直接新建
    public static function CreateTbl($tbl_name) {
        $sql = "create table if not exists "."`". $tbl_name."` like `xhprof_data`;";
        $db = MysqlLib::GetInstance(['dbname'=>'game-tools']);
        $db->link->query($sql)->execute();
    }

    // 数据库表是否存在 不存在则直接新建
    public static function GetUserXhprofTblOfUid($uid) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('xhprof_set', ['db_tab', 'ip'], [
            'uid' => $uid
        ])[0];
    }
}
