<?php
namespace Gm\Model;
use Gm\Core\MysqlLib;
use Gm\Lib\Medoo;
class Users {

    // 获取用户信息
    public static function Login($username, $password)
    {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        $data = $db->link->select('user', ['id', 'username', 'password', 'avatar', 'status'],
            ['username' => $username, 'password' => $password]);
        if(!isset($data[0])) {
            return false;
        }
        return $data[0];
    }

    // 通过uid获取用户menu信息
    public static function GetUserMenuIdByUid($uid)
    {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('user_menu_relation', '*'
            , ['user_id' => $uid]);
    }

    // 获取用户
    public static function GetUserList($search, $page, $limit) {
        $pageBegin = ($page-1)*$limit;
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($search)) {
            return $db->link->select('user', '*', ['LIMIT' => [$pageBegin, $limit]]);
        } else {
            return $db->link->select('user', '*',
                ['username[~]' => $search, 'LIMIT' => [$pageBegin, $limit]]);
        }
    }

    // 获取符合条件的条数
    public static function GetUserCount($search) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($search)) {
            $data = $db->link->count('user', '*');
        } else {
            $data = $db->link->count('user', '*', ['username[~]' => $search]);
        }
        return $data;
    }

    // 增加用户
    public static function AddUser($username, $password, $avatar, $status, $desc) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->insert('user',
                [
                    'username' => $username,
                    'password' => $password,
                    'avatar' => $avatar,
                    'desc' => $status,
                    'status' => $desc,
                ]
            );
    }

    // 通过名称获取用户信息
    public static function GetUserByUsername($username) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('user', '*'
            , ['username' => $username])[0];
    }

    // 增加用户菜单关联
    public static function AddUserMenuID($uid, $mid) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->insert('user_menu_relation'
            , ['user_id' => $uid, 'menu_id' => $mid]);
    }

    // 修改用户
    public static function UpdateUser($id, $username, $password, $avatar, $status, $desc) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->update('user'
            , ['userName' => $username, 'password' => $password, 'avatar' => $avatar,
                'desc' => $desc, 'status' => $status]
            , ['id' => $id]);
    }

    // 删除用户菜单关联
    public static function DeleteUserMenuID($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->delete('user_menu_relation', ['user_id' => $id]);
    }

    // id删除用户
    public static function DeleteUserById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->delete('user', ['id' => $id]);
    }

    // 通过id获取用户
    public static function GetUserById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        $data = $db->link->select('user', "*",
            ['id' => $id]);
        return $data[0];
    }

    // 修改用户token
    public static function SaveToken($id, $token) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->update('user', ['token' => $token], ['id' => $id]);
    }

}