<?php
namespace Gm\Model;
use Gm\Core\MysqlLib;
class Servers {

    // 获取区服列表
    public static function GetServerList($search, $page, $limit) {
        $pageBegin = ($page-1)*$limit;
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($search)) {
            $data = $db->link->select('server', '*', [
                'ORDER' => ['id' => 'DESC'],
                'LIMIT' => [$pageBegin, $limit],
            ]);
        } else {
            $data = $db->link->select('server', '*', [
                'name[~]' => $search,
                'ORDER' => ['id' => 'DESC'],
                'LIMIT' => [$pageBegin, $limit],
            ]);
        }
        return $data;
    }

    public static function GetServerListByPlatform($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($id)) {
            $data = $db->link->select('server', '*', [
                'ORDER' => ['server_id' => 'ASC'],
            ]);
        } else {
            $data = $db->link->select('server', '*', [
                'platform_id' => $id,
                'ORDER' => ['server_id' => 'ASC'],
            ]);
        }
        return $data;
    }

    // 获取所有区服 不分页
    public static function GetServerInfo() {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('server', '*', [
            'ORDER' => ['server_id' => 'ASC'],
        ]);
    }

    // 获取所有道具
    public static function GetItemList($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        $item = $db->link->select('server','*', 'item_id', [
            'id' => $id
        ])[0];
//        var_dump($item);
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('item', '*', [
            'item_cfg_id' => $item['item_id']
        ]);
    }

    // 获取符合条件的条数
    public static function GetServerCount($search) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($search)) {
            $count = $db->link->count('server', '*');
        } else {
            $count = $db->link->count('server', '*', ['name[~]' => $search]);
        }
        return $count;
    }

    // 增加区服
    public static function AddServer($name, $server_id, $game_url, $config, $desc, $platform_id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->insert('server', [
            'server_id' => $server_id,
            'game_url' => $game_url,
            'platform_id' => $platform_id,
            'name' => $name,
            'config' => $config,
            'desc' => $desc,
        ]);
    }

    // 通过名称获取用户信息
    public static function GetServerByName($name) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('server', '*', [
            'name' => $name
        ])[0];
    }

    // 修改区服
    public static function UpdateServer($id, $name, $server_id, $game_url, $config, $desc, $item_id, $platform_id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->update('server', [
            'name' => $name, 'server_id' => $server_id, 'game_url' => $game_url, 'config' => $config,
            'item_id' => $item_id, 'platform_id' => $platform_id, 'desc' => $desc
        ], [
            'id' => $id
        ]);
    }

    // id删除区服
    public static function DeleteServerById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->delete('server', [
            'id' => $id
        ]);
    }


    // 通过id获取区服
    public static function GetServerById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('server', '*',['id' => $id])[0];
    }

    // 通过区服id获取区服
    public static function GetServerByServerId($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('server', '*', ['server_id' => $id])[0];
    }

    public static function GetServerUseItemCfg($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('server', '*', ['item_id' => $id]);
    }

    public static function GetServerUsePlatform($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('server', '*', ['platform_id' => $id]);
    }

    // 修改不能同一个区服id
    public static function editServerIDIsHave($id, $sid) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('server', '*', ['server_id' => $sid, 'id[!]' => $id]);
    }

    // 道具存入数据库
    public static function ItemInsDB($arr, $id): bool {
        // 删除之前的配置
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        $db->link->delete('item', ['item_cfg_id' => $id]);

        // 存入数据
        foreach($arr as $item) {
            $db->link->insert('item', [
                'item_id' => $item['itemID'],
                'name' => $item['itemName'],
                'item_cfg_id' => $id,
            ]);
        }

        // 修改状态
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        $db->link->update('item_cfg', ['status' => 1], ['id' => $id]);
        return true;
    }

    //--------------------------------------------item--------------------------------------------------------
    // 获取道具配置列表
    public static function GetItemCfgList($page, $limit) {
        $pageBegin = ($page-1)*$limit;
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('item_cfg', '*', [
            'del_flag' => 0,
            'ORDER' => ['id' => 'DESC'],
            'LIMIT' => [$pageBegin, $limit],
        ]);
    }

    // 获取符合条件的条数
    public static function GetItemCount() {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->count('item_cfg', '*', [
            'del_flag' => 0
        ]);
    }

    // 增加道具信息
    public static function AddItemCfg($desc) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        $date = date('Y-m-d H:i:s');
        return $db->link->insert('item_cfg', [
            'desc' => $desc,
            'date' => $date
        ]);
    }
    // 获取道具通过id
    public static function GetItemCfgById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('item_cfg', '*', ['id' => $id])[0];
    }

    // 修改道具配置
    public static function UpdateItemCfg($id, $desc) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        $date = date('Y-m-d H:i:s');
        return $db->link->update('item_cfg', [
            'desc' => $desc,
            'date' => $date,
        ], [
            'id' => $id
        ]);
    }

    // 删除道具配置
    public static function DeleteItemCfgById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->delete('item_cfg', ['id' => $id]);
    }

    // 通过区服id获取区服
    public static function CheckItemStatusIsHave($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('item_cfg', '*', [
            'status' => 1,
            'id' => $id
        ])[0];
    }

    //--------------------------------------------platform--------------------------------------------------------
    // 获取区服列表
    public static function GetPlatformList($page, $limit) {
        $pageBegin = ($page-1)*$limit;
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('platform', '*', [
            'ORDER' => ['id' => 'DESC'],
            'LIMIT' => [$pageBegin, $limit],
        ]);
    }

    // 获取符合条件的条数
    public static function GetPlatformCount() {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->count('platform', '*');
    }

    // 增加平台信息
    public static function AddPlatform($name, $desc) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->insert('platform', [
            'name' => $name,
            'desc' => $desc
        ]);
    }
    // 获取平台通过id
    public static function GetPlatformById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('platform', '*', ['id' => $id])[0];
    }
    // 修改平台配置
    public static function UpdatePlatform($id, $name ,$desc) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->update('platform', [
            'desc' => $desc,
            'name' => $name
        ], [
            'id' => $id
        ]);
    }

    // 删除平台配置
    public static function DeletePlatformById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->delete('platform', ['id' => $id]);
    }

}