<?php
namespace Gm\Model;
use Gm\Core\MysqlLib;
class Notices {

    // 获取公告列表
    public static function GetNoticeList($search, $page, $limit, $time_start, $time_end, $status) {
        $pageBegin = ($page-1)*$limit;
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if(empty($status)) {
            if (empty($search)) {
                $data = $db->link->select('notice', '*', [
                    'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                    'LIMIT' => [$pageBegin, $limit],
                ]);
            } else {
                $data = $db->link->select('notice', '*', [
                    'time_send[<>]' => [$time_start, $time_end],
                    'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                    'LIMIT' => [$pageBegin, $limit],
                ]);
            }
        } else {
            if($status == 1) {
                if (empty($search)) {
                    $data = $db->link->select('notice', '*', [
                        'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                        'time_send[>]' => time(),
                        'LIMIT' => [$pageBegin, $limit],
                    ]);
                } else {
                    $data = $db->link->select('notice', '*', [
                        'time_send[<>]' => [$time_start, $time_end],
                        'time_send[>]' => time(),
                        'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                        'LIMIT' => [$pageBegin, $limit],
                    ]);
                }
            } elseif ($status == 2) {
                if (empty($search)) {
                    $data = $db->link->select('notice', '*', [
                        'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                        'time_send[<]' => time(),
                        'time_end[>]' => time(),
                        'LIMIT' => [$pageBegin, $limit],
                    ]);
                } else {
                    $data = $db->link->select('notice', '*', [
                        'time_send[<>]' => [$time_start, $time_end],
                        'time_send[<]' => time(),
                        'time_end[>]' => time(),
                        'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                        'LIMIT' => [$pageBegin, $limit],
                    ]);
                }
            } elseif($status == 3) {
                if (empty($search)) {
                    $data = $db->link->select('notice', '*', [
                        'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                        'time_end[<]' => time(),
                        'LIMIT' => [$pageBegin, $limit],
                    ]);
                } else {
                    $data = $db->link->select('notice', '*', [
                        'time_send[<>]' => [$time_start, $time_end],
                        'time_end[<]' => time(),
                        'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                        'LIMIT' => [$pageBegin, $limit],
                    ]);
                }
            } elseif($status == 4) {
                if (empty($search)) {
                    $data = $db->link->select('notice', '*', [
                        'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                        'time_end[>]' => time(),
                        'LIMIT' => [$pageBegin, $limit],
                    ]);
                } else {
                    $data = $db->link->select('notice', '*', [
                        'time_send[<>]' => [$time_start, $time_end],
                        'time_end[>]' => time(),
                        'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
                        'LIMIT' => [$pageBegin, $limit],
                    ]);
                }
            }

        }

        return $data;
    }

    // 生成公告列表
    public static function BuildNoticeList() {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);

        $data = $db->link->select('notice', '*', [
            'time_end[>]' => time(),
            'ORDER' => ['sort' => 'DESC', 'id' => 'DESC'],
        ]);

        return $data;
    }

    // 获取符合条件的条数
    public static function GetCount($search) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($search)) {
            $count = $db->link->count('notice', '*');
        } else {
            $count = $db->link->count('notice', '*', ['name[~]' => $search]);
        }
        return $count;
    }

    // 增加公告
    public static function AddNotice($title, $title_short, $time_send, $time_end, $sort, $status, $content,
                                     $content_image, $icon) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->insert('notice', [
            'title' => $title,
            'title_short' => $title_short,
            'time_send' => $time_send,
            'time_end' => $time_end,
            'sort' => $sort,
            'status' => $status,
            'content' => $content,
            'content_image' => $content_image,
            'icon' => $icon,
            'time_create' => time(),
        ]);
    }

    // 返回插入id
    public static function findInsID(): int {
        return MysqlLib::GetInstance(['dbname' => 'game-tools'])->link->id();
    }

    // 通过名称获取用户信息
    public static function GetLampByName($name) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('lamp', '*', [
            'name' => $name
        ])[0];
    }

    // 修改公告
    public static function UpdateNotice($id, $title, $title_short, $time_send, $time_end, $sort, $status, $content,
                                        $content_image, $icon) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->update('notice', [
            'title' => $title, 'title_short' => $title_short, 'time_send' => $time_send, 'time_end' => $time_end,
            'sort' => $sort, 'content' => $content, 'content_image' => $content_image, 'status' => $status,
            'icon' => $icon
        ], [
            'id' => $id
        ]);
    }

    // 修改公告
    public static function UpdateLampStatus($id, $status) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->update('lamp', [
            'status' => $status
        ], [
            'id' => $id
        ]);
    }

    // id删除公告
    public static function DeleteNoticeById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->delete('notice', [
            'id' => $id
        ]);
    }

    // 通过id获取公告
    public static function GetNoticeById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('notice', '*',['id' => $id])[0];
    }

}