<?php
namespace Gm\Model;
use Gm\Core\MysqlLib;
class Logs {

    // 获取用户
    public static function GetLogList($search, $type,$page, $limit) {
        $pageBegin = ($page-1)*$limit;
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($search)) {
            $data = $db->link->select('log', '*',[
                'type' => $type,
                'ORDER' => ['id' => 'DESC'],
                'LIMIT' => [$pageBegin, $limit],
            ]);
        } else {
            $data = $db->link->select('log', '*', [
                'type' => $type,
                'user_name[~]' => $search,
                'ORDER' => ['id' => 'DESC'],
                'LIMIT' => [$pageBegin, $limit],
            ]);
        }
        return $data;
    }

    // 获取符合条件的条数
    public static function GetLogCount($search, $type) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($search)) {
            $count = $db->link->count('log', '*', [
                'type' => $type
            ]);
        } else {
            $count = $db->link->count('log', '*', [
                    'type' => $type,
                    'user_name[~]' => $search
                ]);
        }
        return $count;
    }

    public static function InsData($type, $username, $info, $log_data) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        $log_time = date("Y-m-d H:i:s");
        return $db->link->insert('log', [
            'user_name' => $username,
            'log_info' => $info,
            'type' => $type,
            'log_time' => $log_time,
            'log_data' => $log_data,
        ]);
    }
}