<?php
namespace Gm\Model;
use Gm\Core\MysqlLib;
class Lamps {

    // 获取跑马灯列表
    public static function GetLampList($search, $page, $limit, $time_start, $time_end) {
        $pageBegin = ($page-1)*$limit;
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($search)) {
            $data = $db->link->select('lamp', '*', [
                'ORDER' => ['id' => 'DESC'],
                'LIMIT' => [$pageBegin, $limit],
            ]);
        } else {
            $data = $db->link->select('lamp', '*', [
//                'name[~]' => $search,
                'time_start[<>]' => [$time_start, $time_end],
                'ORDER' => ['id' => 'DESC'],
                'LIMIT' => [$pageBegin, $limit],
            ]);
        }
        return $data;
    }

    // 获取符合条件的条数
    public static function GetLampCount($search) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        if (empty($search)) {
            $count = $db->link->count('lamp', '*');
        } else {
            $count = $db->link->count('lamp', '*', ['name[~]' => $search]);
        }
        return $count;
    }

    // 增加跑马灯
    public static function AddLamp($name, $servers, $time_s, $time_e, $num, $content, $user_name) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->insert('lamp', [
            'name' => $name,
            'servers' => $servers,
            'time_start' => $time_s,
            'time_end' => $time_e,
            'num' => $num,
            'content' => $content,
            'status' => 1,
            'user_name' => $user_name,
            'time_create' => time(),
        ]);
    }

    // 返回插入id
    public static function findInsID(): int {
        return MysqlLib::GetInstance(['dbname' => 'game-tools'])->link->id();
    }

    // 通过名称获取用户信息
    public static function GetLampByName($name) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->select('lamp', '*', [
            'name' => $name
        ])[0];
    }

    // 修改跑马灯
    public static function UpdateLamp($id, $name, $servers, $time_start, $time_end, $num, $content) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->update('lamp', [
            'name' => $name, 'servers' => $servers, 'time_start' => $time_start, 'time_end' => $time_end,
            'num' => $num, 'content' => $content
        ], [
            'id' => $id
        ]);
    }

    // 修改跑马灯
    public static function UpdateLampStatus($id, $status) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->update('lamp', [
            'status' => $status
        ], [
            'id' => $id
        ]);
    }

    // id删除跑马灯
    public static function DeleteLampById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        return $db->link->delete('lamp', [
            'id' => $id
        ]);
    }

    // 通过id获取跑马灯
    public static function GetLampById($id) {
        $db = MysqlLib::GetInstance(['dbname' => 'game-tools']);
        $arr = $db->link->select('lamp', '*',['id' => $id]);
        if(!empty($arr)) {
            return $db->link->select('lamp', '*',['id' => $id])[0];
        }
        return [];
    }

}