<?php

namespace Gm\Core;

use Gm\Config\MysqlConfig;
use Gm\Lib\Medoo;

class MysqlLib {

    private $type;
    private $host;
    private $port;
    private $user;
    private $pwd;
    private $dbname;
    private $charset;
    public  Medoo $link;
    private static $instance;

    // 私有构造
    private function __construct($params) {
        $this->initParam($params);
        $this->initConnect();
    }

    // 私有clone
    private function __clone(){}

    // 获取单例
    public static function GetInstance($params=[]): MysqlLib
    {
        if (!self::$instance instanceof self) {
            self::$instance = new self($params);
        }
        return self::$instance;
    }

    private function initParam($params) {
        $this->type    = MysqlConfig::type     ?? 'mysql';
        $this->host    = MysqlConfig::hostname ?? '192.168.0.23';
        $this->port    = MysqlConfig::port     ?? '3306';
        $this->user    = MysqlConfig::username ?? 'root';
        $this->pwd     = MysqlConfig::password ?? 'root';
        $this->dbname  = $params['dbname']     ?? 'xhprof';
        $this->charset = MysqlConfig::charset  ?? 'utf8mb4';
    }

    private function initConnect() {
        $this->link = new Medoo([
            'type' => $this->type,
            'host' => $this->host,
            'port' => $this->port,
            'database' => $this->dbname,
            'username' => $this->user,
            'password' => $this->pwd,
            'charset' => $this->charset,
        ]);
//        $this->link = @mysqli_connect(
//            $this->host,
//            $this->user,
//            $this->pwd,
//            $this->dbname,
//            $this->port
//        );
//        if (mysqli_connect_error()) {
//            echo 'errInfo' . mysqli_connect_error() . '<br>';
//        }
//        mysqli_set_charset($this->link, $this->charset);
    }
//
//    // 执行数据库的增删改查
//    private function execute($sql) {
//        if(!$rs=mysqli_query($this->link, $sql)) {
//            echo 'SQL语句执行失败<br>';
//            echo '错误信息:'. mysqli_error($this->link), '<br>';
//            echo '错误码:'.mysqli_errno($this->link), '<br>';
//            echo '错误的SQL语句:'. $sql . '<br>';
//            exit;
//        }
//        return $rs;
//    }
//
//    // 执行增删改 返回boolen值 成功返回true 失败 false
//    public function exec($sql) {
//        $key=substr($sql, 0, 6);
//        if(in_array($key, array('insert', 'update', 'delete', 'create', 'trunca')))
//            return $this->execute($sql);
//        else {
//            echo '非法访问<br>';
//            exit;
//        }
//    }
//
//    // 获取自动增长的编号
//    public function getLastInsertId() {
//        return mysqli_insert_id($this->link);
//    }
//
//    // 执行查询语句
//    private function query($sql) {
//        if (substr($sql, 0, 6) == 'select' || substr($sql, 0, 4) == 'show' || substr($sql, 0, 6) == 'create' || substr($sql, 0, 4) == 'desc') {
//            return $this->execute($sql);
//        } else {
//            echo '非法访问<br>';
//            exit;
//        }
//    }
//
//    // 将查询结果改为二维度数组
//    public function fetchAll($sql, $type='assoc') {
//        $rs = $this->query($sql);
//        $type = $this->getType($type);
//        return mysqli_fetch_all($rs, $type);
//    }
//
//    // 只有一条记录 应该返回一条记录
//    public function fetchRow($sql, $type='assoc') {
//        $list = $this->fetchAll($sql, $type);
//        if (!empty($list))
//            return $list[0];
//        return array();
//    }
//
//    // 获取匹配类型
//    private function getType($type) {
//        switch($type) {
//            case 'num':
//                return MYSQLI_NUM;
//            case 'both':
//                return MYSQLI_BOTH;
//            default:
//                return MYSQLI_ASSOC;
//        }
//    }
//
//
//

}
