<?php
namespace Gm\Controller;
/**
 * Class Xhprof
 * desc  性能分析类
 */
use Gm\Model\Xhprofs;
use Gm\Lib\Jwt;
use Gm\Comm\CommFunc;

class Xhprof {
    use CommFunc;
    public function __construct() {

    }

    // 获取信息
    public function GetInfo() {
        $userInfo = Jwt::verifyToken();
        // 获取用户性能分析数据库表
        $setData = Xhprofs::GetUserXhprofTblOfUid($userInfo['info']['id']);
//        if(empty($_GET['db_tab'])) {
//            $db_tab = 'xhprof_data';
//        } else {
//            $db_tab = explode('--', $_GET['db_tab'])[1];
//        }
        $option = $_GET['search'] ?? "";
        $pageIndex = $_GET['page'] ?? 1;
        $pageSize = $_GET['limit'] ?? 10;
        $pageBegin = ($pageIndex-1)*$pageSize;
//        var_dump($setData);

        // 检测表是否存在
        if (!Xhprofs::DbTableIsHave($setData['db_tab'])) {
            $this->ReturnErr(400, '查询的数据库表不存在，请重新填写选择！');
            return ;
        }

        $data = Xhprofs::GetInfo($setData['db_tab'], $option, $pageSize, $pageBegin);
        if (!is_array($data)) {
            $this->ReturnErr(400, '请求格式有误');
            return ;
        }

        $count = Xhprofs::GetCount($setData['db_tab'], $option);

        $data = [
            "list" => $data,
            "total" => (int)$count,
            "ip" => $setData['ip']
        ];
        $this->ReturnSucc(200, $data);

    }

    // 获取配置信息
    public function GetSetInfo() {
        $jwt_token = Jwt::verifyToken();
        $uid = $jwt_token['info']['id'];
        $name = $_GET['search'] ?? "";
        $pageIndex = $_GET['page'] ?? 1;
        $pageSize = $_GET['limit'] ?? 10;
        $pageBegin = ($pageIndex-1)*$pageSize;

        $data = Xhprofs::GetSetInfo($name, $pageSize, $pageBegin, $uid);
        if (!is_array($data)) {
            $this->ReturnErr(400, '请求格式有误');
            return ;
        }

        $count = Xhprofs::GetSetCount($name);

        $data = [
            "list" => $data,
            "total" => (int)$count
        ];
        $this->ReturnSucc(200, $data);
    }

    // 新增和修改xhprof信息
    public function Save() {
        $params = json_decode(file_get_contents("php://input"));
        $id = $params->id;
        $name = $params->name;
        $ip = $params->ip;
        $db_tab = $params->db_tab;
        if(empty($id)) {
            // 判断配置名称是否存在
            if($this->xhprofIsHaveByName($name)) {
                $this->ReturnErr(500, "配置名称已经存在，请勿重复添加！");
                return ;
            }

            // 检测表是否存在
            if (Xhprofs::DbTableIsHave($db_tab)) {
                $this->ReturnErr(400, '需要新建的数据库表已存在，请重新填写！');
                return ;
            }

            Xhprofs::CreateTbl($db_tab);

            // 存储用户数据
            $uid = Jwt::verifyToken()['info']['id'];
            if(Xhprofs::AddXhprofSet($name, $ip, $db_tab, $uid)) {
                $this->ReturnSucc(200);
            } else {
                $this->ReturnErr(500, "信息创建失败");
            }
        } else {

//            Xhprofs::CreateTbl($db_tab);

            // 修改用户数据
            if(Xhprofs::UpdateXhprofSet($id, $name, $ip, $db_tab)) {
                $this->ReturnSucc(200);
            } else {
                $this->ReturnErr(500, "信息更新失败");
            }
        }
    }

    public function XhprofSetInfo() {
        $id = $_GET['id'];
        $xhprofSet = Xhprofs::GetXhprofSetById($id);
        if(empty($xhprofSet)) {
            $this->ReturnErr(500, '操作失败');
        } else {
            $this->ReturnSucc(200, $xhprofSet);
        }
    }

    public function xhprofIsHaveByName($name) {
        $res = Xhprofs::GetXhprofSetInfoByName($name);
        if(empty($res)) {
            return false;
        }

        return true;
    }

    public function Delete() {
        $params = json_decode(file_get_contents("php://input"));
        $id = $params->id;

        if(Xhprofs::DeleteXhporfSetById($id)) {
            $this->ReturnSucc(200, '删除成功');
        } else {
            $this->ReturnErr(500, "删除配置信息失败");
        }
    }

    public function GetAllXhprofTab() {
        $tabs = Xhprofs::GetAllXhprofTab();
//        var_dump($tabs);
        $res = [];
        if (!empty($tabs)) {
            foreach ($tabs as $v) {
                $res[] = ['value' => $v['name'] . '--' . $v['db_tab']];
            }
        }
        if(empty($tabs)) {
            $this->ReturnErr(500, '操作失败');
        } else {
            $this->ReturnSucc(200, $res);
        }
    }
}