<?php
namespace Gm\Controller;
/**
 * Class Log
 * Desc  日志类（前端部分底层显示）
 */

use Gm\Config\ErrorCode;
use Gm\Model\Logs;
use Gm\Comm\CommFunc;

class Log {
    use CommFunc;
    public function __construct() {

    }

    // 用户列表
    public function GetData() {

        $params = json_decode(file_get_contents("php://input"));
        $search = $params->search;
        $type = $params->type;
        $page = $params->page;
        $limit = $params->limit;

        $data = Logs::GetLogList($search, $type,$page, $limit);
        $count = Logs::GetLogCount($search, $type);
        $r = [
            "data" => $data,
            "count" => (int)$count
        ];
        $this->ReturnSucc(ErrorCode::SUCCESS, ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC],$r);
    }

}