<?php
namespace Gm\Controller;
/**
 * Class Gm
 * Desc  游戏工具（发送道具、金币...）
 */

use Game\Protobuf\GMCarProficiency;
use Game\Protobuf\GMChangeDevelopmentalTask;
use Game\Protobuf\GMChangeExp;
use Game\Protobuf\GMClearRank;
use Game\Protobuf\GMCompleteTask;
use Game\Protobuf\GMOpenGameLevel;
use Game\Protobuf\GMSeasonScore;
use Game\Protobuf\GMServerState;
use Game\Protobuf\GMUpdateFrinedIntimacy;
use Game\Protobuf\MGCarProficiency;
use Game\Protobuf\MGChangeDevelopmentalTask;
use Game\Protobuf\MGChangeExp;
use Game\Protobuf\MGClearRank;
use Framework\Log\LogMark;
use Game\Protobuf\MGCompleteTask;
use Game\Protobuf\MGOpenGameLevel;
use Game\Protobuf\MGSeasonScore;
use Game\Protobuf\MGServerState;
use Game\Protobuf\MGUpdateFrinedIntimacy;
use Game\Protobuf\PacketId;
use Game\Protobuf\GMGainItem;
use Game\Protobuf\GMRankScore;
use Game\Protobuf\GMSearchPlayerInfo;
use Game\Protobuf\GMSendMail;
use Game\Protobuf\Item;
use Game\Protobuf\MGGainItem;
use Game\Protobuf\MGGainMoney;
use Game\Protobuf\MGRankScore;
use Game\Protobuf\MGSearchPlayerInfo;
use Game\Protobuf\MGSendMail;

use Gm\Model\Servers;
use Gm\Model\Gms;
use Gm\Model\Logs;
use Gm\Lib\Jwt;
use Gm\Comm\CommFunc;
use Gm\Config\ErrorCode;

class Gm {
    use CommFunc;

    public const TYPE_ACCOUNT_MAIL = 1; // 用户邮件
    public const TYPE_COMMON_MAIL = 2;  // 系统邮件

    public const USER_LOG_TYPE = 2;
    public const ITEM_LOG_TYPE = 3;
    public const MONEY_LOG_TYPE = 4;
    public const ACCOUNT_LOG_TYPE = 5;
    public const MAIL_LOG_TYPE = 6;
    public const PAIWEI_LOG_TYPE = 7;
    public const CLEAR_RANK_LOG_TYPE = 8;
    public const CAR_PROFICIENCY_LOG_TYPE = 9;
    public const LAMP_LOG_TYPE = 10;
    public const NOTICE_LOG = 11;
    public const LAMP_OPEN_GAME_LEVEL = 12;
    public const LAMP_INTIMACY = 13;
    public const LOG_MODULE = 14;
    public const OUT_PLAYER = 15;
    public const BAN_PLAYER = 16;
    public const PROHIBITION_PLAYER = 17;
    public const SVN_UP = 18;
    public const EXP_CHANGE = 19;
    public const TASK_CHANGE = 20;
    public const TASK_COMPLETE = 21;

    public const DATA = 'data';
    public const INFO = 'info';
    public const MSG  = 'msg';
    public const TOKEN = 'Token';
    public const USERNAME = 'username';
    public const NAME = 'name';

    public function __construct() {

    }

    // 区服列表
    public function GetServerList(): void
    {
        $platform = $_GET['id'];
        $data = Servers::GetServerListByPlatform($platform);
        $r = [
            self::DATA => $data,
        ];
        $this->ReturnSucc(ErrorCode::SUCCESS, ErrorCode::CODE_MAP[ErrorCode::SUCCESS], $r);
    }

    // 道具列表
    public function GetItemList(): void
    {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $data = Servers::GetItemList($server_id);
        $res = [];
        foreach ($data as $item) {
            $line = [
                'id' => $item['item_id'],
                'value' => $item[self::NAME],
            ];
            $res[] = $line;
        }
        $r = [
            self::DATA => $res,
        ];
        $this->ReturnSucc(ErrorCode::SUCCESS, ErrorCode::CODE_MAP[ErrorCode::SUCCESS], $r);
    }

    /*
     * res   [data:"arr 返回数据", info:"str log信息", msg: "json 存库信息"]
     */
    public function CheckAPIResult(int $code, array $res, int $type, string $user, bool $log = true): bool
    {
        if(!isset(ErrorCode::CODE_MAP[$code])) {
            $this->ReturnErr($code, ErrorCode::CODE_MAP[ErrorCode::PARAMS_ERROR]);
            return false;
        }
        if($code === ErrorCode::SUCCESS) {
            $this->ReturnSucc($code, ErrorCode::CODE_MAP[$code], $res[self::DATA]);
            if($log) {
                Logs::InsData($type, $user, ErrorCode::CODE_MAP[$code]. $res[self::INFO], $res[self::MSG]);
            }
            return true;
        }

        $this->ReturnErr($code, ErrorCode::CODE_MAP[$code]);
        Logs::InsData($type, $user, ErrorCode::CODE_MAP[$code].$res[self::INFO], $res[self::MSG]);
        return false;
    }

    // 增加道具
    public function ExecGainItem() {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $items = $params->data;
        $itemArr = [];
        $itemLog = [];
        $user = Jwt::verifyToken();
        $server_info = Servers::GetServerById($server_id);
        $token = getallheaders()[self::TOKEN];

        foreach ($items as $obj) {
            $itemSingle = new Item();
            $itemSingle->setItemID($obj->item_id);
            $itemSingle->setItemNum($obj->item_num);
            $itemSingle->setTimeOut($obj->time_out);
            $itemLog[] = [
                'itemID' => $obj->item_id,
                'itemNum' => $obj->item_num,
                'timeOut' => $obj->time_out,
            ];
            $itemArr[] = $itemSingle;
        }

        $itemMsg = new MGGainItem();
        $itemMsg->setAccount($nick_name);
        $itemMsg->setItemList($itemArr);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_GainItem, $token, $itemMsg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_GAIN_ITEM_SAVE_DB_FAILED,
                'send gain items save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_GainItem, self::TOKEN => $token]
            );
            $info = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 增加道具失败！' . json_encode($itemLog);
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAIN_ITEM_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $info,
                    self::MSG => $info,
                ],
                Gm::ITEM_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_GainItem, $data, $code, $server_id)) {
            if($code != 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::ITEM_LOG_TYPE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'send gain items get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_GainItem, self::TOKEN => $token]
            );
            $info = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 增加道具失败！' . json_encode($itemLog);
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO =>  $info,
                    self::MSG => $info,
                ],
                Gm::ITEM_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $accountGM = new GMGainItem();
        $accountGM->mergeFromString($resData);
        $code = $accountGM->getCode();

        if($code === ErrorCode::SUCCESS) {
            $res[self::DATA] = $code;
            $res[self::INFO] = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 增加道具成功！' . json_encode($itemLog);
            $res[self::MSG] = json_encode($itemLog);
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 增加道具失败！';
            $res[self::MSG] = json_encode($itemLog);
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::ITEM_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );
    }

    // 执行脚本增加货币
    public function ExecGainMoney() {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $money_type = (int)$params->money_type;
        $money_num = (int)$params->money_num;
        $user = Jwt::verifyToken();
        $server_info = Servers::GetServerById($server_id);
        $token = getallheaders()[self::TOKEN];

        $moneyMsg = new MGGainMoney();
        $moneyMsg->setAccount($nick_name);
        $moneyMsg->setType($money_type);
        $moneyMsg->setNum($money_num);

        $moneyLog = [
            'Type' => $money_type,
            'Num' => $money_num,
        ];

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_GainMoney, $token, $moneyMsg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_GAIN_MONEY_SAVE_DB_FAILED,
                'send gain money save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_GainMoney, self::TOKEN => $token]
            );
            $info = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 增加货币失败！' . json_encode($moneyLog);
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAIN_MONEY_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $info,
                    self::MSG => $info,
                ],
                Gm::MONEY_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_GainMoney, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::MONEY_LOG_TYPE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'send gain money get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_GainMoney, self::TOKEN => $token]
            );
            $info = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 增加货币失败！' . json_encode($moneyLog);
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $info,
                    self::MSG  => $info,
                ],
                Gm::MONEY_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $moneyGM = new GMGainItem();
        $moneyGM->mergeFromString($resData);
        $code = $moneyGM->getCode();

        if($code === ErrorCode::SUCCESS) {
            $res[self::DATA] = '发送货币成功';
            $res[self::INFO] = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 增加货币成功！' . json_encode($moneyLog);
            $res[self::MSG] = json_encode($moneyLog);
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 增加货币失败！' . json_encode($moneyLog);
            $res[self::MSG] = json_encode($moneyLog);
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::MONEY_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );
    }

    // 修改好友亲密度
    public function UpdateIntimacy() {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $target_nick_name = $params->target_nick_name;
        $score = $params->score;
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 发送数据
        $accountMsg = new MGUpdateFrinedIntimacy();
        $accountMsg->setAccount($nick_name);
        $accountMsg->setTargetAccount($target_nick_name);
        $accountMsg->setScore($score);
        if(!Gms::SaveMsgDB($server_id, PacketId::MG_UpdateFrinedIntimacy, $token, $accountMsg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_UPDATE_INTIMACY_SAVE_DB_FAILED,
                'update intimacy save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_UpdateFrinedIntimacy, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_UPDATE_INTIMACY_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::LAMP_INTIMACY, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_UpdateFrinedIntimacy, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::LAMP_INTIMACY, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'open game level timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::GM_UpdateFrinedIntimacy, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::LAMP_INTIMACY, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $accountGM = new GMUpdateFrinedIntimacy();
        $accountGM->mergeFromString($resData);
        $code = $accountGM->getCode();

        if($code === ErrorCode::SUCCESS) {

            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = json_encode([]);
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::LAMP_INTIMACY,
            $user[self::INFO][self::USERNAME],
        );
    }

    // 一键通关
    public function OpenGameLevel() {

        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 发送数据
        $accountMsg = new MGOpenGameLevel();
        $accountMsg->setAccount($nick_name);
        if(!Gms::SaveMsgDB($server_id, PacketId::MG_OpenGameLevel, $token, $accountMsg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_OPEN_GAME_LEVEL_SAVE_DB_FAILED,
                'open game level save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_OpenGameLevel, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_OPEN_GAME_LEVEL_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::LAMP_OPEN_GAME_LEVEL, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_OpenGameLevel, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::LAMP_OPEN_GAME_LEVEL, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'open game level timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::GM_OpenGameLevel, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::LAMP_OPEN_GAME_LEVEL, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $accountGM = new GMOpenGameLevel();
        $accountGM->mergeFromString($resData);
        $code = $accountGM->getCode();

        if($code === ErrorCode::SUCCESS) {

            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = json_encode([]);
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::ACCOUNT_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );
    }

    // 查询玩家信息
    public function SearchPlayerInfo() {

        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 发送数据
        $accountMsg = new MGSearchPlayerInfo();
        $accountMsg->setAccount($nick_name);
        if(!Gms::SaveMsgDB($server_id, PacketId::MG_SearchPlayerInfo, $token, $accountMsg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_ACCOUNT_SAVE_DB_FAILED,
                'search player info save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_SearchPlayerInfo, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_ACCOUNT_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::ACCOUNT_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_SearchPlayerInfo, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::ACCOUNT_LOG_TYPE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'search player info get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_SearchPlayerInfo, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::ACCOUNT_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $accountGM = new GMSearchPlayerInfo();
        $accountGM->mergeFromString($resData);
        $code = $accountGM->getCode();
        $account = $accountGM->getAccount();

        if($code === ErrorCode::SUCCESS) {
            $info = json_decode($account, true);
            // 转时间
            if(isset($info['loginTime']) && !empty($info['loginTime'])) {
                $info['loginTime'] = date('Y-m-d H:i:s', (int)$info['loginTime']);
            }
            // id处理
            if(isset($info['playerID']) && !empty($info['playerID'])) {
                $info['playerID'] = (string)$info['playerID'];
            }
            $res[self::DATA] = $info;
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = json_encode($info);
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::ACCOUNT_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );
    }

    //GM发送邮件 nick_name为 'system' 系统邮件
    public function SendMail()
    {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $mail_id = (int)$params->mail_id;          //邮件模板id
        $create_time = (int)$params->create_time;  //邮件创建时间
        $items = $params->data;                   //附件
        $server_info = Servers::GetServerById($server_id);
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];
        $itemArr = [];
        $mailLog = [];

        $type = self::TYPE_ACCOUNT_MAIL;
        if($nick_name === 'system') {
            $type = self::TYPE_COMMON_MAIL;
        }

        foreach ($items as $obj) {
            $itemSingle = new Item();
            $itemSingle->setItemID($obj->item_id);
            $itemSingle->setItemNum($obj->item_num);
            $itemSingle->setTimeOut($obj->time_out);
            $mailLog[] = [
                'itemID' => $obj->item_id,
                'itemNum' => $obj->item_num,
                'timeOut' => $obj->time_out,
            ];
            $itemArr[] = $itemSingle;
        }

        $mailMsg = new MGSendMail();
        $mailMsg->setAccount($nick_name);
        $mailMsg->setCreateTime($create_time);
        $mailMsg->setMailID($mail_id);
        $mailMsg->setItemList($itemArr);
        $mailMsg->setType($type);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_SendMail, $token, $mailMsg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_SEND_MAIL_SAVE_DB_FAILED,
                'send mail save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_SendMail, self::TOKEN => $token]
            );
            $info = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 发送邮件失败！' . json_encode(['mailID' => $mail_id, $mailLog]);
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_SEND_MAIL_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $info,
                    self::MSG => $info,
                ],
                Gm::MAIL_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_SendMail, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::MAIL_LOG_TYPE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'send mail get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_GainItem, self::TOKEN => $token]
            );
            $info = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 发送邮件失败！' . json_encode(['mailID' => $mail_id, $mailLog]);
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO =>  $info,
                    self::MSG => $info,
                ],
                Gm::MAIL_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $mailGM = new GMSendMail();
        $mailGM->mergeFromString($resData);
        $code = $mailGM->getCode();

        if($code === ErrorCode::SUCCESS) {
            $res[self::DATA] = $code;
            $res[self::INFO] = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 发送邮件成功！' . json_encode(['mailID' => $mail_id, $mailLog]);
            $res[self::MSG] = json_encode(['mailID' => $mail_id, $mailLog]);
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = $user[self::INFO][self::USERNAME] . '给区服' . $server_info[self::NAME] . ' '. $nick_name.
                ' 发送邮件失败！';
            $res[self::MSG] = json_encode(['mailID' => $mail_id, $mailLog]);
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::MAIL_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );
    }

    //修改排位赛积分,保护分
    public function UpdatePaiWeiScore()
    {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $score = (int)$params->score;              // 积分
        $guard_score = (int)$params->guard_score;  // 保护分
        $option = (int)$params->option;            // 操作类型 1查询 2修改
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 组装数据
        $msg = new MGRankScore();
        $msg->setAccount($nick_name);
        $msg->setOption($option);
        $msg->setScore($score);
        $msg->setGuardScore($guard_score);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_RankScore, $token, $msg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_RANK_SOCRE_SAVE_DB_FAILED,
                'send rank score save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_RankScore, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_RANK_SOCRE_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::PAIWEI_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_RankScore, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::PAIWEI_LOG_TYPE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'search rank info get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_RankScore, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::PAIWEI_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $rankMsg = new GMRankScore();
        $rankMsg->mergeFromString($resData);
        $code = $rankMsg->getCode();
        $info = $rankMsg->getInfo();

        if($code == ErrorCode::SUCCESS) {
            $res = json_decode($info, true);
            $res[self::DATA] = $res;
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = $info;
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::ACCOUNT_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );
    }

    // 执行删除排行榜（个人和榜单清除）
    public function ExecDelRank() {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $rank_type = (int)$params->rank_type;
        $map_id = (int)$params->map_id;
        $option = (int)$params->option;
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        $clearRankMsg = new MGClearRank();
        $clearRankMsg->setOption($option);
        $clearRankMsg->setAccount($nick_name);
        $clearRankMsg->setRankType($rank_type);
        $clearRankMsg->setMapID($map_id);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_ClearRank, $token, $clearRankMsg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_CLEAR_RANK_SAVE_DB_FAILED,
                'send clear rank save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_ClearRank, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_CLEAR_RANK_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => '',
                    self::MSG => '',
                ],
                Gm::CLEAR_RANK_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_ClearRank, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::CLEAR_RANK_LOG_TYPE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'send clear rank get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_GainMoney, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => '',
                    self::MSG  => '',
                ],
                Gm::CLEAR_RANK_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $msg = new GMClearRank();
        $msg->mergeFromString($resData);
        $code = $msg->getCode();

        if($code === ErrorCode::SUCCESS) {
            $res[self::DATA] = '删除成功';
            $res[self::INFO] = '删除成功！';
            $res[self::MSG] ='删除成功！';

        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = '删除失败！';
            $res[self::MSG] ='删除失败！';
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::CLEAR_RANK_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );

    }

    //修改排位赛积分,保护分
    public function UpdateCarProficiency()
    {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $carId = (int)$params->car_id;
        $proficiency_lv = (int)$params->proficiency_lv;      //熟练度等级
        $proficiency = (int)$params->proficiency;   //熟练度经验
        $option = (int)$params->option;            // 操作类型 1查询 2修改
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 组装数据
        $msg = new MGCarProficiency();
        $msg->setAccount($nick_name);
        $msg->setCarId($carId);
        $msg->setOption($option);
        $msg->setProficiencyLv($proficiency_lv);
        $msg->setProficiency($proficiency);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_CarProficiency, $token, $msg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_CAR_PROFICIENCY_SAVE_DB_FAILED,
                'send car proficiency save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_CarProficiency, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_CAR_PROFICIENCY_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                self::CAR_PROFICIENCY_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_CarProficiency, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    self::CAR_PROFICIENCY_LOG_TYPE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'search car proficiency get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::GM_CarProficiency, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                self::PAIWEI_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $rankMsg = new GMCarProficiency();
        $rankMsg->mergeFromString($resData);
        $code = $rankMsg->getCode();
        $carInfo = $rankMsg->getCar();

        if($code == ErrorCode::SUCCESS) {
            $car = [
                'carID' => $carInfo->getCarId(),
                'proficiencyLv' => $carInfo->getProficiencyLv(),
                'proficiency' => $carInfo->getProficiency()
            ];
            $res[self::DATA] = $car;
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = json_encode($car);
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG]  = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            self::ACCOUNT_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );
    }

    //修改排位赛积分,保护分
    public function UpdateSeasonScore()
    {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $season_score = (int)$params->season_score;      //熟练度等级
        $option = (int)$params->option;            // 操作类型 1查询 2修改
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 组装数据
        $msg = new MGSeasonScore();
        $msg->setAccount($nick_name);
        $msg->setOption($option);
        $msg->setSeasonScore($season_score);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_SeasonScore, $token, $msg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_CAR_PROFICIENCY_SAVE_DB_FAILED,
                'send season score save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_CarProficiency, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_CAR_PROFICIENCY_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                self::CAR_PROFICIENCY_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_SeasonScore, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    self::CAR_PROFICIENCY_LOG_TYPE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'search car proficiency get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::GM_CarProficiency, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                self::PAIWEI_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $seasonMsg = new GMSeasonScore();
        $seasonMsg->mergeFromString($resData);
        $code = $seasonMsg->getCode();

        if($code == ErrorCode::SUCCESS) {
            $info = [
                'seasonID' => $seasonMsg->getSeasonID(),
                'seasonScore' => $seasonMsg->getSeasonScore(),
                'overFlowExp' => $seasonMsg->getOverFlowExp(),
                'haveNum' => $seasonMsg->getHaveNum(),
                'num' => $seasonMsg->getNum()
            ];
            $res[self::DATA] = $info;
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = json_encode($info);
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG]  = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            self::ACCOUNT_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );
    }

    //  查询修改服务器状态
    public function UpdateServerState()
    {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $state = (int)$params->server_state;
        $option = (int)$params->option;            // 操作类型 1查询 2修改
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 组装数据
        $msg = new MGServerState();
        $msg->setOption($option);
        $msg->setState($state);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_ServerState, $token, $msg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_UPDATE_SERVER_STATE_SAVE_DB_FAILED,
                'send server state save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_ServerState, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_UPDATE_SERVER_STATE_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                self::USER_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_ServerState, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    self::USER_LOG_TYPE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'search Server state get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::GM_ServerState, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                self::USER_LOG_TYPE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $seasonMsg = new GMServerState();
        $seasonMsg->mergeFromString($resData);
        $code = $seasonMsg->getCode();
        $state = $seasonMsg->getState();

        if($code == ErrorCode::SUCCESS) {
            $info = [
                'serverState' => $state,
            ];
            $res[self::DATA] = $info;
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = json_encode($info);
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG]  = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            self::USER_LOG_TYPE,
            $user[self::INFO][self::USERNAME],
        );
    }


    // 修改玩家经验
    public function UpdatePlayerExp()
    {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $exp = (int)$params->exp;              // 经验
        $option = (int)$params->option;        // 操作类型 1查询 2修改
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 组装数据
        $msg = new MGChangeExp();
        $msg->setAccount($nick_name);
        $msg->setOption($option);
        $msg->setExp($exp);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_ChangeExp, $token, $msg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_CHANGE_EXP_SAVE_DB_FAILED,
                'send change exp save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_ChangeExp, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_CHANGE_EXP_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::EXP_CHANGE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_ChangeExp, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::EXP_CHANGE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'search change exp get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::GM_ChangeExp, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::EXP_CHANGE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $rankMsg = new GMChangeExp();
        $rankMsg->mergeFromString($resData);
        $code = $rankMsg->getCode();
        $info = $rankMsg->getInfo();

        if($code == ErrorCode::SUCCESS) {
            $res = json_decode($info, true);
            $res[self::DATA] = $res;
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = $info;
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::EXP_CHANGE,
            $user[self::INFO][self::USERNAME],
        );
    }


    // 修改成长任务
    public function UpdateDevelopmentalTask()
    {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $level = (int)$params->level;
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 组装数据
        $msg = new MGChangeDevelopmentalTask();
        $msg->setAccount($nick_name);
        $msg->setLevel($level);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_ChangeDevelopmentalTask, $token, $msg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_CHANGE_TASK_SAVE_DB_FAILED,
                'send change task save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_ChangeExp, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_CHANGE_TASK_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::TASK_CHANGE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_ChangeDevelopmentalTask, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::TASK_CHANGE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'search change task get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::GM_ChangeDevelopmentalTask, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::TASK_CHANGE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $msg = new GMChangeDevelopmentalTask();
        $msg->mergeFromString($resData);
        $code = $msg->getCode();

        if($code == ErrorCode::SUCCESS) {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = [];
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::TASK_CHANGE,
            $user[self::INFO][self::USERNAME],
        );
    }


    // 修改成长任务
    public function CompleteTask()
    {
        $params = json_decode(file_get_contents("php://input"));
        $server_id = (int)$params->server_id;
        $nick_name = $params->nick_name;
        $taskID = (int)$params->taskID;
        $user = Jwt::verifyToken();
        $token = getallheaders()[self::TOKEN];

        // 组装数据
        $msg = new MGCompleteTask();
        $msg->setAccount($nick_name);
        $msg->setTaskID($taskID);

        if(!Gms::SaveMsgDB($server_id, PacketId::MG_CompleteTask, $token, $msg)) {
            LogMark::getInstance()->markError(
                ErrorCode::ERROR_COMPLETE_TASK_SAVE_DB_FAILED,
                'send complete task save msg db error!',
                ['serverID' => $server_id, 'packetID' => PacketId::MG_CompleteTask, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_COMPLETE_TASK_SAVE_DB_FAILED,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::TASK_COMPLETE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }
        // 取出返回数据
        $code = 0;
        if(!Gms::SearchMsgDB($token, PacketId::GM_CompleteTask, $data, $code, $server_id)) {
            if($code !== 0) {
                $this->CheckAPIResult(
                    $code,
                    [
                        self::DATA => [],
                        self::INFO =>  ErrorCode::CODE_MAP[$code],
                        self::MSG => ErrorCode::CODE_MAP[$code],
                    ],
                    Gm::TASK_COMPLETE, $user[self::INFO][self::USERNAME]
                );
                return ;
            }
            // 超时处理
            LogMark::getInstance()->markWarn(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                'search complete task get data timeout!',
                ['serverID' => $server_id, 'packetID' => PacketId::GM_CompleteTask, self::TOKEN => $token]
            );
            // 返回失败
            $this->CheckAPIResult(
                ErrorCode::ERROR_GAME_SERVER_TIMEOUT,
                [
                    self::DATA => [],
                    self::INFO => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                    self::MSG => $user[self::INFO][self::USERNAME] . ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR],
                ],
                Gm::TASK_COMPLETE, $user[self::INFO][self::USERNAME]
            );
            return ;
        }

        // 解析数据
        $resData = base64_decode($data);
        $msg = new GMCompleteTask();
        $msg->mergeFromString($resData);
        $code = $msg->getCode();

        if($code == ErrorCode::SUCCESS) {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_SUCC];
            $res[self::MSG] = [];
        } else {
            $res[self::DATA] = [];
            $res[self::INFO] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
            $res[self::MSG] = ErrorCode::CODE_MAP[ErrorCode::SEARCH_ERR];
        }

        $this->CheckAPIResult(
            $code,
            $res,
            Gm::TASK_COMPLETE,
            $user[self::INFO][self::USERNAME],
        );
    }
}
