<?php
/**
 * error code
 * @author LeeFx
 */
namespace Gm\Config;

class ErrorCode {

    // server error log code
    public const PARAMS_ERROR                      = 50;   // 参数错误
    public const SEARCH_SUCC                       = 51;   // 查询成功
    public const SEARCH_ERR                        = 52;   // 查询失败
    public const ERROR_ACCOUNT_SAVE_DB_FAILED      = 100;  // 账号信息存储失败
    public const ERROR_GAME_SERVER_TIMEOUT         = 101;  // 取数据超时-设置时间内游戏服务器没有返回数据
    public const ERROR_GAIN_ITEM_SAVE_DB_FAILED    = 102;  // 发送道具存储失败
    public const ERROR_GAIN_MONEY_SAVE_DB_FAILED   = 103;  // 发送货币存储失败
    public const ERROR_SEND_MAIL_SAVE_DB_FAILED    = 104;  // 发送邮件存储失败
    public const ERROR_RANK_SOCRE_SAVE_DB_FAILED   = 105;  // 发送排位积分存储失败
    public const ERROR_GAME_SERVER_EXEC_FAILED     = 106;  // 游戏服处理失败
    public const ERROR_EXEC_SUCCESS                = 800;  // 执行成功
    public const ERROR_EXEC_FAILED                 = 801;  // 执行成功
    public const ERROR_CHANGE_EXP_SAVE_DB_FAILED   = 802;  // 发送修改经验存储失败
    public const ERROR_CHANGE_TASK_SAVE_DB_FAILED   = 803;  // 发送修改成长任务存储失败
    public const ERROR_COMPLETE_TASK_SAVE_DB_FAILED   = 804;  // 完成任务失败

    public const ERROR_CLEAR_RANK_SAVE_DB_FAILED   = 107;  // 发送清理排行榜失败
    public const ERROR_CAR_PROFICIENCY_SAVE_DB_FAILED = 108;  // 发送修改车熟练度失败

    public const ERROR_LAMP_EDIT_FAILED = 109;  // 跑马灯修改与增加
    public const ERROR_LAMP_SEARCH_FAILED = 110;  // 跑马灯查询

    public const ERROR_LAMP_SAVE_DB_FAILED    = 111;  // 发送跑马灯存库失败
    public const ERROR_LAMP_CANCEL_FAILED    = 112;  // 撤销失败

    public const ERROR_LAMP_CANCEL_SAVE_DB_FAILED    = 113;  // 撤销跑马灯存库失败
    public const ERROR_OPEN_GAME_LEVEL_SAVE_DB_FAILED      = 114;  // 账号信息存储失败
    public const ERROR_UPDATE_INTIMACY_SAVE_DB_FAILED      = 115;  // 修改亲密度
    public const ERROR_UPDATE_SERVER_STATE_SAVE_DB_FAILED      = 116;  // 修改服务器状态失败
    public const ERROR_SERVER_MODULE_SAVE_DB_FAILED = 117;  // 模块修改保存失败
    public const ERROR_OUT_PLAYER_SAVE_DB_FAILED = 118;     // 踢玩家
    public const ERROR_BAN_PLAYER_SAVE_DB_FAILED = 119;     // 封禁玩家
    public const ERROR_PROHIBITION_PLAYER_SAVE_DB_FAILED = 120;     // 禁言玩家
    public const ERROR_SVN_UP_SAVE_DB_FAILED = 120;     // svn更新



    // client error code
    public const SUCCESS                    = 200;
    public const SUCCESS_1                    = 0;

    public const ERROR_PARAMS_FAILED        = 201;    // 参数错误
    public const ERROR_ACCOUNT_NOT_FOUND    = 202;    // 账号不存在于服务器
    public const ERROR_TPL_ID_CAN_NOT       = 203;    // 道具不存在
    public const ERROR_SERVER_FAILED        = 204;    // 服务器内部错误
    public const ERROR_RUN_FAILED           = 205;    // 操作失败
    public const ERROR_MAIL_TPL_NOT_FOUND   = 206;    // 邮件模板不存在
    public const ERROR_COMMON_MAIL_ADD_FAIL = 207;   // 添加系统邮件失败
    public const CAR_NOT_FOUND = 208;   //车不存在
    public const CAR_NOT_FOREVER = 209; //车不是永久车
    public const CAR_PROFICIENCY_CAN_NOT_SUB = 210;     //熟练度不能减少
    public const CAR_PROFICIENCY_OVER_MAX = 211;        //超过最高熟练度等级
    public const ERROR_SERVICE_FAIL         = 280;    // service 处理失败
    public const ERROR_TARGET_NOT_FRIEND = 281; //对方不是好友
    public const ERROR_SUB_FRIEND_INTIMACY_LESS_ZERO = 282; //扣除亲密度为负数
    public const ERROR_SVN_UP_FAILED = 283; // svn up执行失败
    public const ERROR_ITEM_NOT_SEND = 284; // 此道具无法发放

    public const ERROR_GM_INTERNAL          = 500;
    // token校验失败
    public const ERROR_TOKEN_IS_FAILED = 501;
    // 同一用户 不同设备登录
    public const ERROR_USER_REPEAT = 555;
    public const ERROR_CAR_ADD_NOT_OPEN     = 600;   // 车没有开启
    public const ERROR_LAMP_TIME_FAILED     = 700;   // 跑马灯时间格式错误
    public const ERROR_TASK_NOT_FOUND     = 1000;   // 跑马灯时间格式错误

    public const CODE_MAP = [
        self::SEARCH_SUCC => '查询成功!',
        self::SEARCH_ERR => '查询失败!',
        self::PARAMS_ERROR => '参数错误！',
        self::SUCCESS => '操作成功',
        self::ERROR_ACCOUNT_SAVE_DB_FAILED => '查询账号服务器发送信息失败！',
        self::ERROR_GAIN_ITEM_SAVE_DB_FAILED => '发送道具服务器发送信息失败！',
        self::ERROR_GAME_SERVER_TIMEOUT => '服务器获取数据超时！',

        self::ERROR_PARAMS_FAILED => '参数错误，操作失败！',

        self::ERROR_ACCOUNT_NOT_FOUND => '账号不存在，操作失败！!',
        self::ERROR_TPL_ID_CAN_NOT => '道具不存在，操作失败！',
        self::ERROR_SERVER_FAILED => '服务器内部错误，操作失败！',
        self::ERROR_RUN_FAILED => '服务器运行错误，操作失败！',
        self::ERROR_MAIL_TPL_NOT_FOUND => '邮件模板不存在，操作失败！',
        self::ERROR_COMMON_MAIL_ADD_FAIL => '添加系统邮件失败！',
        self::ERROR_CAR_ADD_NOT_OPEN => '车辆未开启！',
        self::CAR_NOT_FOUND => "未拥有此车",
        self::CAR_NOT_FOREVER => "车辆不是永久车",
        self::CAR_PROFICIENCY_CAN_NOT_SUB => "不能减少熟练度等级",
        self::CAR_PROFICIENCY_OVER_MAX => "超过最高熟练度等级",
        self::ERROR_LAMP_EDIT_FAILED => "跑马灯操作失败",
        self::ERROR_LAMP_SAVE_DB_FAILED => "跑马灯发送失败",
        self::ERROR_LAMP_SEARCH_FAILED => "跑马灯查询失败",
        self::SUCCESS_1 => "操作成功",
        self::ERROR_LAMP_CANCEL_FAILED => "撤销跑马灯失败",
        self::ERROR_LAMP_CANCEL_SAVE_DB_FAILED => "撤销跑马灯存库失败",
        self::ERROR_OPEN_GAME_LEVEL_SAVE_DB_FAILED =>'一键通关发送信息失败',
        self::ERROR_TARGET_NOT_FRIEND => "对方不是好友",
        self::ERROR_SUB_FRIEND_INTIMACY_LESS_ZERO => "扣除亲密度后为负数",
        self::ERROR_UPDATE_SERVER_STATE_SAVE_DB_FAILED => "修改服务器状态失败",
        self::ERROR_EXEC_SUCCESS => " 更新成功",
        self::ERROR_EXEC_FAILED => " 更新失败",
        self::ERROR_CHANGE_EXP_SAVE_DB_FAILED => " 发送修改经验存储失败",
        self::ERROR_ITEM_NOT_SEND => "改装件无法发放",
        self::ERROR_CHANGE_TASK_SAVE_DB_FAILED => "成长任务保存失败",
        self::ERROR_COMPLETE_TASK_SAVE_DB_FAILED => "任务完成保存失败",
        self::ERROR_TASK_NOT_FOUND => "任务不存在"
    ];
}
