<?php
namespace Gm\Config;
use Gm\CLI\Service;
use Gm\CLI\LampTimer;
use \Gm\Controller\Service as CService;

class Config {
    public const WRITE_SERVER_LIST_DIR = __DIR__ . '/../dist/GameLogicListInfo.txt';  // 服务器列表
    public const NOTICE_TEMPLATE_DIR = __DIR__ . '/../Lib/notice/notice.html';  // 读取notice html 模板
    public const NOTICE_LIST_DIR = __DIR__ . '/../dist/notice.html';  // 写入最新内容文件
    public const DEFAULT_GAME_SERVER_ID = 1;
    public const TOKEN_TIMEOUT = 86400;        // token过期时间
    public const LOG_PATH = "GmServer";
    public const REQUEST_TIME_OUT = 5;      // 请求阻塞时间
    public const SERVICE_TIME_OUT = 0;      // CLI请求阻塞时间
    public const SERVICE_LOG_PATH = "GmService";
    public const GM_ID = 1;
    public const SERVICE = Service::class;
    public const LAMP_TIMER = LampTimer::class;
    public const SERVICE_CONTROLLER = CService::class;
    public const MODEL_SERVICE = [1 => 'Test'];
    public const SVN_DIR_MAP = [
        0 => '/data/shell/svnUp/svn_up_alpha.sh',
        1 => '/data/shell/svnUp/svn_up_zxl.sh',
        2 => '/data/shell/svnUp/svn_up_ljl.sh',
        3 => '/data/shell/svnUp/svn_up_zj.sh',
        4 => '/data/shell/svnUp/svn_up_yb.sh',
        5 => '/data/shell/svnUp/svn_up_bh.sh',
        6 => '/data/shell/svnUp/svn_up_zs.sh',
    ];

}