<?php

/**
 * 定获取类的实例
 */

namespace Gm\Comm;

trait Singletons
{
    private static self $instance;
    /**
     * 获取类的静态对象
     * @return self 本类静态对象
     */
    public static function getInstance(): self
    {
        if (!isset(self::$instance)) {
            //这里不能new self(),self和static区别
            self::$instance = new static();
        }
        return self::$instance;
    }
}
