<?php

/**
 * 游戏入口
 * Created On 2021/11/1
 * @author yuanb yuanbo0x@gmail.com
 */

require_once __DIR__ . "/Library/AutoLoad.php";

use Framework\Define\ErrorDefine;
use Framework\Network\ReceiveMessage;
use Framework\Network\SendMessage;
use Game\Config\GameConfig;
use Game\GameLive;
use Game\Constant\TestParams;

$testObj = new TestParams();
$testObj::$startTime = microtime(true);

if (!isset($_GET['zone'])) {
    echo "Zone Error";
    return;
}
$zone = $_GET['zone'];

GameLive::getInstance()->InitZone($zone);
GameLive::getInstance()->InitLog(GameConfig::getInstance()->LOG_PATH());
GameLive::getInstance()->InitException();
GameLive::getInstance()->InitDefineConfig();

$error_id = ReceiveMessage::getInstance()->checkQuest();
if ($error_id == ErrorDefine::SUCCESS) {
    GameLive::getInstance()->InitProtagonistPlayerId(ReceiveMessage::getInstance()->getPlayerId());
    try {
       $error_id = ReceiveMessage::getInstance()->run();
    } catch (Throwable $exception) {
        GameLive::getInstance()->catchException($exception);
    }
}
if ($error_id != ErrorDefine::SUCCESS) {
    SendMessage::getInstance()->sendErrorClient($error_id);
}

GameLive::getInstance()->GameOver();

$testObj::$endTime = microtime(true);
$testObj->writeLogInfo();
