<?php

namespace Game\Operation\SDK\ThinkData;

use Game\Operation\EventLog\CompleteTaskLog;
use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;

class ThinkTaskEvent extends ThinkDataEvent
{
    public function GetEventName()
    {
        $this->eventName = "Task";
    }

    public function GetLogType()
    {
        return EventLogType::CompleteTask;
    }
    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var CompleteTaskLog $log
         */
        $this->eventValues = array(
            "task_id" => $log->taskId,
            "t_type" => $log->taskType,
            "item" => json_encode($log->reward),
            "car_id" => $log->carId,
        );
        return true;
    }
}
