<?php

namespace Game\Operation\SDK\ThinkData;

use Framework\Log\LogMark;
use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;
use Game\Operation\EventLog\StartPVPLog;

class ThinkStartPVPEvent extends ThinkDataEvent
{
    public function GetEventName()
    {
        $this->eventName = "PVP";
    }

    public function GetLogType()
    {
        return EventLogType::StartPVP;
    }

    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var StartPVPLog $log
         */
        $this->eventValues = array(
            "game_id" => $log->matchType,
            "racingId" => $log->matchUid,
            "play_grop" => $log->playerDan,
            "car_id" => $log->playerCarId,
            "car_pr" => $log->playerCarPerformance,
            "player_num" => $log->playerNum,
        );
        return true;
    }
}
