<?php

namespace Game\Operation\SDK\ThinkData;

use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;
use Game\Operation\EventLog\StartPVELog;

class ThinkStartPVEEvent extends ThinkDataEvent
{

    public function GetEventName()
    {
        $this->eventName = "PVE";
    }

    public function GetLogType()
    {
        return EventLogType::StartPVE;
    }

    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var StartPVELog $log
         */
        $this->eventValues = array(
            "chapte_num" => $log->chapterId,
            "chapte_cup_num" => $log->chapterStarNum,
            "item" => $log->chapterRewardStatus,
            "dungeon_id" => $log->levelId,
            "car_id" => $log->carId
        );
        return true;
    }
}
