<?php

namespace Game\Operation\SDK\ThinkData;

use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;
use Game\Operation\EventLog\LogoutLog;

class ThinkLogoutEvent extends ThinkDataEvent
{
    public function GetEventName()
    {
        $this->eventName = "Logout";
    }

    public function GetLogType()
    {
        return EventLogType::Logout;
    }

    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var LogoutLog $log
         */
        $this->eventValues = array(
            "diamond_num" => $log->diamond,
            "point_num" => $log->ticket,
            "gold_num" => $log->gold,
            "online_time" => $log->online_time
        );
        return true;
    }
}
