<?php

namespace Game\Operation\SDK\ThinkData;

use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;
use Game\Operation\EventLog\LoginLog;

class ThinkLoginEvent extends ThinkDataEvent
{
    //SKD字段
    private array $loginData = array(
        "first" => LoginLog::NOT_FIRST_LOGIN,
//        "age" => 0,
//        "gender" => 0,
        "diamond_num" => 0,
        "point_num" => 0,
        "gold_num" => 0
    );

    public function GetEventName()
    {
        $this->eventName = "Login";
    }

    public function GetLogType()
    {
        return EventLogType::Login;
    }

    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var LoginLog $log
         */
        //检查首次登陆
        if ($log->first == LoginLog::FIRST_LOGIN) {
            $this->eventName = "First";
            $this->loginData['first'] = LoginLog::FIRST_LOGIN;
            $this->loginData['imsi'] = $log->imsi;
            $this->loginData['mac'] = $log->mac;
        }
        $this->loginData['diamond_num'] = $log->diamond;
        $this->loginData['point_num'] = $log->ticket;
        $this->loginData['gold_num'] = $log->gold;
        $this->eventValues = $this->loginData;
        return true;
    }
}
