<?php

namespace Game\Operation\SDK\ThinkData;

use Game\Operation\EventLog\AddItemLog;
use Game\Operation\EventLog\ConsumeItemLog;
use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;

class ThinkItemConsumeEvent extends ThinkDataEvent
{
    public function GetEventName()
    {
        $this->eventName = "Consume";
    }

    public function GetLogType()
    {
        return EventLogType::ItemConsume;
    }

    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var ConsumeItemLog $log
         */
        $this->eventValues = array(
            "item_id" => $log->itemId,
            "item_num" => $log->costNum,
            "item_num_odd" => $log->newNum,
            "reason" => $log->source,
        );
        return true;
    }
}
