<?php

namespace Game\Operation\SDK\ThinkData;

use Game\Operation\EventLog\AddItemLog;
use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;

class ThinkItemAddEvent extends ThinkDataEvent
{
    public function GetEventName()
    {
        $this->eventName = "Award";
    }

    public function GetLogType()
    {
        return EventLogType::ItemAdd;
    }

    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var AddItemLog $log
         */
        $this->eventValues = array(
            "task_id" => $log->taskId,
            "item_id" => $log->itemId,
            "number" => $log->addNum,
            "time" => $log->expireTime,
            "reason" => $log->source,
        );
        return true;
    }
}
