<?php


namespace Game\Operation\SDK\ThinkData;


use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;

abstract class ThinkDataEvent
{
    /**
     * 具体sdk的事件数据数组
     * @var array
     */
    public array $eventValues;

    /**
     * 具体sdk的事件名字
     * @var string
     */
    public string $eventName;

    abstract public function GetEventName();

    abstract public function GetLogType();

    public function init()
    {
        $this->GetEventName();
        $this->GetLogType();
    }

    //解析日志 整理为对应SDK需要的数据格式
    public function parsingLog(EventLog $log): bool
    {
        return true;
    }

}