<?php

namespace Game\Operation\SDK\ThinkData;

use Game\Operation\EventLog\CompletePVELog;
use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;

class ThinkCompletePVEEvent extends ThinkDataEvent
{
    public function GetEventName()
    {
        $this->eventName = "OverPVE";
    }

    public function GetLogType()
    {
        return EventLogType::CompletePVE;
    }

    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var CompletePVELog $log
         */
        $this->eventValues = array(
            "game_id" => $log->matchType,
            "task_career" => $log->pveUnCompleteTask,
            "racingid" => $log->levelId,
            "car_id" => $log->playerCarId,
            "record" => $log->playerMark->getCostTime(),
            "new_record_pve" => $log->newRecord,
            "km_num" => $log->matchOperation->getDrivingRange(),
            "turbine_num" => $log->matchOperation->getSpray1Num(),
            "nitro_num" => $log->matchOperation->getN2Num(),
            "skill_num" => $log->matchOperation->getSkillNum(),
        );
        return true;
    }
}
