<?php

namespace Game\Operation\SDK\ThinkData;

use Game\Constant\GameConstantDefine;
use Game\Operation\EventLog\CompleteMatchLog;
use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;
use Game\Protobuf\RaceResult;

class ThinkCompleteMatchEvent extends ThinkDataEvent
{
    public function GetEventName()
    {
        $this->eventName = "Over";
    }

    public function GetLogType()
    {
        return EventLogType::CompleteMatch;
    }

    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var CompleteMatchLog $log
         */
        $this->eventValues = array(
            "map_id" => $log->mapId,
            "game_id" => $log->matchType,
            "racingid" => $log->matchUid,
            //赛车ID|赛车等级
            "car_id" => $log->playerCarId,
            //比赛队友成绩	玩家ID\机器人标记\赛车ID
            "teamrecord" => $this->tidyMatchRaceResult($log->playerId, $log->raceResultList),
            "level" => $log->addCarProficiency,
            "proficiency_num" => $log->addCarProficiency,
            "cup_num" => $log->addScore,
            "ranking" => $log->playerRaceResult->getTime() > 0 ? $log->playerRaceResult->getRank() : 0,
            "team_victory" => $log->playerTeamWin,
            "record" => $log->playerRaceResult->getTime(),
            "new_record_pvp" => $log->playerBreakingInfo->serializeToJsonString(),
            "mvp" => (int)$log->playerRaceResult->getMvp(),
            "golden" => $this->getIcon($log->playerRaceResult),
            "interceptor_num" => $log->playerRaceResult->getJamNum(),
            "support_num" => $log->playerRaceResult->getHelpNum(),
            "drift_distance" => $log->playerParameter->getDriftRange(),
            "fault_num" => 0,
            "adv_operation" => $log->playerParameter->serializeToJsonString(),
            "win_repeat" => $log->playerRaceResult->getContinuityWin(),
            "perfect_match" => $log->perfectMatch,
            "km_num" => $log->playerParameter->getDrivingRange(),
            "turbine_num" => $log->playerParameter->getSpray1Num(),
            "nitro_num" => $log->playerParameter->getN2Num(),
            "skill_num" => $log->playerParameter->getSkillNum(),
        );
        return true;
    }

    //1=竞速金牌、2=干扰金牌、3=辅助金牌、0=没有金牌
    private function getIcon(RaceResult $raceResult): int
    {
        if ($raceResult->getRaceIcon()) {
            return 1;
        }
        if ($raceResult->getJamIcon()) {
            return 2;
        }
        if ($raceResult->getHelpIcon()) {
            return 3;
        }
        return 0;
    }

    //整理队友成绩
    private function tidyMatchRaceResult(int $playerId, array $raceResultList): string
    {
        $teamRecord = array();
        foreach ($raceResultList as $raceResult) {
            /**
             * @var RaceResult $raceResult
             */
            if ($playerId == $raceResult->getPlayerId()) {
                continue;
            }
            $tmp = array(
                "playerId" => $raceResult->getPlayerId(),
                "AI" => strlen($raceResult->getPlayerId()) <= 9999999,
                "carId" => $raceResult->getCarId()
            );
            $teamRecord[] = $tmp;
        }
        return json_encode($teamRecord);
    }

}
