<?php

namespace Game\Operation\SDK\ThinkData;

use Game\Operation\EventLog\CarUpdateLog;
use Game\Operation\EventLog\EventLog;
use Game\Operation\EventLog\EventLogType;

class ThinkCarEvent extends ThinkDataEvent
{
    public function GetEventName()
    {
        $this->eventName = "Car";
    }

    public function GetLogType()
    {
        return EventLogType::Car;
    }

    public function parsingLog(EventLog $log): bool
    {
        /**
         * @var CarUpdateLog $log
         */
        $this->eventValues = array(
            "car_id" => $log->carId,
            "leveluptype" => $log->updateType,
            "car_leve" => $log->carLv,
            "car_proficiency" => $log->carProficiencyLv,
            "car_pr" => $log->carPerformance,
            "car_equip" => $log->carEquip,
        );
        return true;
    }
}
