<?php

namespace Game\Operation;

use Game\Config\GameConfig;
use Game\Operation\Platform\Platform_TTAbroad;
use Game\Operation\Platform\PlatformBase;
use Library\Common\Singletons;

class PlatformManager
{
    use Singletons;

    protected bool $HasInit = false;

    protected PlatformBase $platform;

    public function init($prefix): bool
    {
        if ($this->HasInit) {
            return true;
        }
        $this->HasInit = $this->init_platform($prefix);
        return $this->HasInit;
    }

    public function close():bool
    {
        if (!$this->HasInit) {
            return false;
        }
        $this->platform->close();
        return true;
    }

    protected function init_platform($prefix): bool
    {
        $channel = GameConfig::getInstance()->CHANNEL_ID();
        if ($channel == 1) {
            $this->platform = new Platform_TTAbroad();
            return $this->platform->Init($prefix);
        }
    }

    public function cli_init_platform($prefix):bool
    {
        return $this->init_platform($prefix);
    }
}