<?php


namespace Game\Operation\Platform;


use Game\GameLive;
use Game\Operation\EventLog\EventLog_Manager;
use Game\Operation\PlatformManager;
use Game\Operation\SDK\ThinkData\SDK_ThinkData;

class Platform_TTAbroad extends PlatformBase
{
    protected SDK_ThinkData $logHandler;

    protected string $thinkDataLogPath = "/data/log/ThinkDataLog";

    public function Init($prefix): bool
    {
        $this->logHandler = new SDK_ThinkData();
        $account = GameLive::getInstance()->playerId;
        $this->logHandler->initSDK(
            $this->thinkDataLogPath,
            $account,
            EventLog_Manager::getInstance()->headData["#distinct_id"],
            $prefix
        );
        EventLog_Manager::getInstance()->setHandler($this->logHandler);
        return true;
    }

    public function close()
    {
        if ($this->logHandler == null) {
            return;
        }
        $this->logHandler->finish();
    }
}