<?php

/**
 * 开始PVP记录
 */

namespace Game\Operation\EventLog;

class StartPVPLog extends EventLog
{
    //比赛信息
    public int $matchType;   //比赛模式
    public string $matchUid;    //比赛唯一Id
    public int $mapId;
    public int $playerNum;  //真人玩家数量
    //玩家信息
    public int $playerDan;   //玩家段位
    public int $playerJoinId;
    //赛车信息
    public int $playerCarId;
    public int $playerCarPerformance;    //车评分
    public int $playerCarProficiencyLv;  //熟练度等级
    public int $playerCarLv;



    public function GetLogType()
    {
        return EventLogType::StartPVP;
    }

    public function CleanUp()
    {
        //清空玩家信息
        $this->playerDan = 0;
        $this->playerJoinId = 0;
        $this->playerCarId = 0;
        $this->playerCarPerformance = 0;
        $this->playerCarProficiencyLv = 0;
        $this->playerCarLv = 0;
    }
}
