<?php


namespace Game\Operation\EventLog;


class EventLogType
{

    public const Login = "Login";
    public const Logout = "Logout";
    public const CompleteTask = "CompleteTask";     //任务完成
    public const ItemAdd = "ItemAdd";   //获得道具
    public const ItemConsume = "ItemConsume";   //消耗道具
    public const Car = "Car";
    public const StartPVP = "StartPVP";
    public const StartPVE = "StartPVE";
    public const CompleteMatch = "CompletePVP"; //pvp比赛结束
    public const CompletePVE = "CompletePVE";   //pve比赛结束
    public const Guide = "Guide";   //新手引导
    public const Performance = "Performance";   //性能指标
    public const Current_online = "Current_online"; //同时在线人数


    public const LOG_TYPE_MAP = array (
        self::Login => LoginLog::class,
        self::Logout => LogoutLog::class,
        self::CompleteTask => CompleteTaskLog::class,
        self::StartPVP => StartPVPLog::class,
        self::StartPVE => StartPVELog::class,
        self::CompleteMatch => CompleteMatchLog::class,
        self::CompletePVE => CompletePVELog::class,
        self::ItemAdd => AddItemLog::class,
        self::ItemConsume => ConsumeItemLog::class,
        self::Car => CarUpdateLog::class,
    );

    public function getEventLogTypeName(string $type): ?string
    {
        return self::LOG_TYPE_MAP[$type] ?? null;
    }

    //用户数据key
    public const LOG_KEY_PLAYER_PROFICIENCY_LV = "PlayerProficiencyLv"; //玩家熟练度等级
    public const LOG_KEY_CAREER_LEVEL_ID = "careerLevelId"; //主线关卡id
    public const LOG_KEY_ROLE_ID = "roleId";
    public const LOG_KEY_ROLE_NAME = "roleName";
    public const LOG_KEY_ROLE_FIRST_LOGIN_TIME = "firstLoginTime";  //首次登陆时间
    public const LOG_KEY_ROLE_REGISTER_TIME = "registerTime";
}