<?php

/**
 * 比赛完成记录,包含PVE和PVP
 */

namespace Game\Operation\EventLog;

use Game\Data\RaceResultData;
use Game\Protobuf\MatchOperation;
use Game\Protobuf\PlayerMark;
use Game\Protobuf\RaceResult;
use Game\Protobuf\RecordBreakingInfo;
use Game\Protobuf\SettlementParameter;

class CompletePVELog extends EventLog
{
    //比赛信息
    public int $matchType;   //比赛模式
    public int $levelId;    //关卡id
    public int $pveUnCompleteTask = 0;    //pve未完成条件,全部完成为0,例:条件1未完成为1
    //赛车信息
    public int $playerCarId;
    public int $playerCarPerformance;    //车评分
    public int $playerCarProficiencyLv;  //熟练度等级
    public int $playerCarLv;
    //玩家结算奖励数据
    public int $playerId;
    public int $newRecord = 0;  //生涯时间突破
    public PlayerMark $playerMark;
    public MatchOperation $matchOperation;  //比赛操作,

    public function GetLogType()
    {
        return EventLogType::CompletePVE;
    }
}
