<?php

/**
 * 比赛完成记录,包含PVE和PVP
 */

namespace Game\Operation\EventLog;

use Game\Data\RaceResultData;
use Game\Protobuf\RaceResult;
use Game\Protobuf\RecordBreakingInfo;
use Game\Protobuf\SettlementParameter;

class CompleteMatchLog extends EventLog
{
    //比赛信息
    public int $matchType;   //比赛模式
    public string $matchUid;    //比赛唯一Id
    public int $mapId;
    public int $perfectMatch = 0;   //完美搭配标记	团队排位：同队（三个类型的车都有，定义叫完美搭配）
    //赛车信息
    public int $playerCarId;
    public int $playerCarPerformance;    //车评分
    public int $playerCarProficiencyLv;  //熟练度等级
    public int $playerCarLv;
    //玩家结算奖励数据
    public int $playerId;
    public int $playerJoinId;
    public int $playerTeamWin;
    public int $addCarProficiency;  //增加车熟练度
    public int $addScore;   //变化的排位积分
    public int $addGuardScore;  //变化的保护分
    public int $matchCarScore;   //比赛车辆评分
    public array $reward; //奖励道具
    public RaceResultData $playerRaceResultData;
    public RaceResult $playerRaceResult;    //名次等信息
    public SettlementParameter $playerParameter;    //玩家的结算参数
    public RecordBreakingInfo $playerBreakingInfo;  //玩家破记录信息
    public array $raceResultList;   //全部的结算结果信息


    public function GetLogType()
    {
        return EventLogType::CompleteMatch;
    }

    public function CleanUp()
    {
        $this->playerCarId = 0;
        $this->playerCarPerformance = 0;
        $this->playerCarProficiencyLv = 0;
        $this->playerCarLv = 0;
        $this->playerJoinId = 0;
        $this->addCarProficiency = 0;
        $this->addScore = 0;
        $this->addGuardScore = 0;
        $this->matchCarScore = 0;
        $this->reward = array();
        $this->playerRaceResultData = new RaceResultData();
        $this->playerRaceResult = new RaceResult();
        $this->playerParameter = new SettlementParameter();
        $this->playerBreakingInfo = new RecordBreakingInfo();
        $this->raceResultList = array();
    }
}
