<?php

/**
 * 增加道具
 */
namespace Game\Operation\EventLog;

class AddItemLog extends EventLog
{
    public int $itemId;
    public int $addNum; //增加的数量
    public int $newNum; //增加后数量
    public int $expireTime;
    public string $source;  //来源
    public int $taskId; //如果是任务获得,记录任务id

    public function GetLogType()
    {
        return EventLogType::ItemAdd;
    }

    public function CleanUp()
    {
        $this->itemId = 0;
        $this->addNum = 0;
        $this->newNum = 0;
        $this->expireTime = 0;
        $this->source = 0;
        $this->taskId = 0;
    }
}
