<?php

/**
 * 主线任务
 */

namespace Game\Model\Task\Manager;

use Framework\Log\LogMark;
use Game\Constant\ConstTemplate\TemplateInitPlayer;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\GameErrorCode;
use Game\Constant\TemplateDefine;
use Game\Data\TaskData;

class MainTaskManager extends TaskMangerModelBase
{
    //初始主线任务 注册完成后
    public function initMainTaskOnRegisterOver()
    {
        $this->setIsRegister();
        $configInitData = $this->getTitle(TemplateDefine::TYPE_INIT_PLAYER, TemplateInitPlayer::DEFAULT_ID);
        $mainTaskId = $configInitData[TemplateInitPlayer::MainTaskId];
        $this->initMainTask($mainTaskId);
    }

    //初始主线任务
    private function initMainTask(int $taskId)
    {
        if (false == $this->createTask($taskId)) {
            LogMark::getInstance()->markError(
                GameErrorCode::TASK_MAIN_CREATE_ERROR,
                "[MainTaskManager] main task create error",
                array(
                    "taskId" => $taskId
                )
            );
        }
    }

    //获取主线任务
    public function getMainTask(): array
    {
        //查询全部主线任务
        $mainTaskList = (new TaskData($this->playerId))->getMainTaskList();
        if (empty($mainTaskList)) {
            //初始主线任务
            $configInitData = $this->getTitle(TemplateDefine::TYPE_INIT_PLAYER, TemplateInitPlayer::DEFAULT_ID);
            $mainTaskId = $configInitData[TemplateInitPlayer::MainTaskId];
            $this->initMainTask($mainTaskId);
            $mainTaskList = (new TaskData($this->playerId))->getMainTaskList();
        }
        $taskList = array();
        $completeTaskList = array();
        foreach ($mainTaskList as $taskId => $status) {
            if ($status == TaskData::STATUS_OVER) {
                $completeTaskList[] = $taskId;
            } else {
                $taskData = $this->getTask($taskId);
                if (!is_null($taskData) && $taskData->taskId != 0) {
                    $taskList[] = $taskData;
                }
            }
        }
        return array($taskList, $completeTaskList);
    }

    public function gmCompleteMainTask(int $lv)
    {
        $endTaskId = 30000 + $lv + 1;
        $startTaskId = 30001;
        //查询全部主线任务
        $mainTaskList = (new TaskData($this->playerId))->getMainTaskList();
        for ($taskId = $startTaskId; $taskId <= $endTaskId; $taskId++) {
            if (array_key_exists($taskId, $mainTaskList)) {
                if ($mainTaskList[$taskId] == TaskData::STATUS_DOING) {
                    //已接任务,正在做,状态改为可领取
                    $taskData = $this->getTask($taskId);
                    $taskData->status = TaskData::STATUS_DONE;
                    $taskData->updateTask();
                } else {
                    continue;
                }
            } else {
                //检查任务是否存在
                $taskConfig = $this->getTitle(TemplateDefine::TYPE_TASK, $taskId);
                if (is_null($taskConfig)) {
                    continue;
                }
                //创建任务
                $this->createTask($taskId);
                if ($taskId <= $endTaskId -1) {
                    $taskData = $this->getTask($taskId);
                    $taskData->status = TaskData::STATUS_DONE;
                    $taskData->updateTask();
                }
            }
        }
    }
}
