<?php

/**
 * 限时任务管理
 */

namespace Game\Model\Task\Manager;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Framework\Logic\TimerLogic;
use Game\Constant\ConstTemplate\TemplateInitPlayer;
use Game\Constant\ConstTemplate\TemplateTaskExchange;
use Game\Constant\ConstTemplate\TemplateTaskFestival;
use Game\Constant\ConstTemplate\TemplateTaskTarget;
use Game\Constant\GameErrorCode;
use Game\Constant\TemplateDefine;
use Game\Data\TaskData;
use Game\Logic\ActiveLogic;
use Game\Logic\MailLogic;

class LimitActivityTaskManager extends TaskMangerModelBase
{
    use MailLogic;
    use ActiveLogic;
    use TimerLogic;
    use PlayerDBHandler;

    private ?array $allWelfareWeekTaskDic = null;   //taskId->status

    // 商城类活动
    public function initExchangeTaskOnRegisterOver()
    {
        $this->setIsRegister();
        $this->initExchangeTask($this->getExchangeTaskConfig());
    }

    // 节日类活动
    public function initFestivalTaskOnRegisterOver()
    {
        $this->setIsRegister();
        $this->initFestivalTask($this->getFestivalTaskConfig());
    }

    // 目标类活动
    public function initTargetTaskOnRegisterOver()
    {
        $this->setIsRegister();
        $this->initTargetTask($this->getTargetTaskConfig());
    }

    // 商城任务创建
    private function initExchangeTask(array $tasks)
    {
        foreach ($tasks as $taskId)
        {
            if (false == $this->createTask($taskId)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::TASK_DAILY_CREATE_ERROR,
                    "[LimitActivityTaskManager] LimitActivity task create error",
                    array(
                        "taskId" => $taskId
                    )
                );
                continue;
            }
        }
    }

    // 节日任务创建
    private function initFestivalTask(array $tasks)
    {
        foreach ($tasks as $taskId)
        {
            if (false == $this->createTask($taskId)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::TASK_DAILY_CREATE_ERROR,
                    "[LimitActivityTaskManager] LimitActivity task create error",
                    array(
                        "taskId" => $taskId
                    )
                );
                continue;
            }
        }
    }

    // 目标任务创建
    private function initTargetTask(array $tasks)
    {
        foreach ($tasks as $taskId)
        {
            if (false == $this->createTask($taskId)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::TASK_DAILY_CREATE_ERROR,
                    "[LimitActivityTaskManager] LimitActivity task create error",
                    array(
                        "taskId" => $taskId
                    )
                );
                continue;
            }
        }
    }

    private function getExchangeTaskConfig(): array
    {
        $tasks = [];
        $taskExchange = $this->getTable(TemplateDefine::TYPE_TASK_EXCHANGE);
        if(is_null($taskExchange)) {
            LogMark::getInstance()->markError(GameErrorCode::DATA_SEARCH_ERROR,
                '[LimitActivityTaskManager] get task exchange data error!');
            return $tasks;
        }
        $nowTime = Utils::getServerTimestamp();
        foreach ($taskExchange as $task) {
            // 检测用户开启的活动
            if($nowTime >= $task[TemplateTaskExchange::StartTime] && $nowTime
                <= $task[TemplateTaskExchange::EndTime]) {
                switch ($task[TemplateTaskExchange::TaskType]) {
                    // 商城不是task id
                    case TemplateTaskExchange::TASK_TYPE_SHOP:
                    default:
                        foreach ($task[TemplateTaskExchange::TaskId] as $id) {
                            $tasks[] = $id;
                        }
                        break;
                }
            }
        }

        return $tasks;
    }

    private function getFestivalTaskConfig(): array
    {
        $tasks = [];
        // 节日
        $taskFestival = $this->getTable(TemplateDefine::TYPE_TASK_FESTIVAL);
        if(is_null($taskFestival)) {
            LogMark::getInstance()->markError(GameErrorCode::DATA_SEARCH_ERROR,
                '[LimitActivityTaskManager] get task festival data error!');
            return $tasks;
        }
        $nowTime = Utils::getServerTimestamp();
        foreach ($taskFestival as $task) {
            // 检测用户开启的活动
            if ($nowTime >= $task[TemplateTaskFestival::StartTime] && $nowTime
                <= $task[TemplateTaskFestival::EndTime]) {
                // 需要增加任务
                foreach ($task[TemplateTaskFestival::TaskId] as $id) {
                    $tasks[] = $id;
                }
            }
        }
        return $tasks;
    }

    private function getTargetTaskConfig(): array
    {
        $tasks = [];
        // 目标
        $taskTarget = $this->getTable(TemplateDefine::TYPE_TASK_TARGET);
        if(is_null($taskTarget)) {
            LogMark::getInstance()->markError(GameErrorCode::DATA_SEARCH_ERROR,
                '[LimitActivityTaskManager] get task target data error!');
            return $tasks;
        }
        $nowTime = Utils::getServerTimestamp();
        foreach ($taskTarget as $task) {
            // 检测用户开启的活动
            if($nowTime >= $task[TemplateTaskTarget::StartTime] && $nowTime
                <= $task[TemplateTaskTarget::EndTime]) {
                // 需要增加任务
                foreach ($task[TemplateTaskTarget::TaskId] as $id) {
                    $tasks[] = $id;
                }
            }
        }
        return $tasks;
    }
}
