<?php

/**
 * 好友亲密度活动
 */

namespace Game\Model\Task\Manager;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ConstTemplate\TemplateInitPlayer;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\FriendIntimacyRewardData;
use Game\Data\TaskData;
use Game\Model\EventModel;
use Game\Protobuf\GCUpdateFriendIntimacyScore;
use Game\Protobuf\PacketId;

class FriendIntimacyTaskManager extends TaskMangerModelBase
{
    use PlayerDBHandler;

    private ?array $allFriendIntimacyTaskDic = null;   //taskId->status

    //初始任务
    public function initFriendIntimacyTask(int $playerId = 0)
    {
        //TODO:不好的方法 待修改
        if ($playerId != 0) {
            /**
             * @var EventModel $eventModel
             */
            $eventModel = ModelManager::getInstance()->getModel(ModelTypeDefine::EVENT);
            $eventModel->setPlayerId($playerId);
        }
        $taskConfigList = $this->getFriendIntimacyConfig();
        foreach ($taskConfigList as $taskId) {
            if (false == $this->createTask($taskId)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::TASK_CREATE_ERROR,
                    "[FriendIntimacyTaskManager] task create error",
                    array(
                        "taskId" => $taskId
                    )
                );
                continue;
            }
        }
    }

    //获取全部任务--校验开启后调用
    public function getFriendIntimacyTask(): array
    {
        if (is_null($this->allFriendIntimacyTaskDic)) {
            $this->getFriendIntimacyTaskDic();
        }
        if (empty($this->allFriendIntimacyTaskDic)) {
            //初始任务
            $this->initFriendIntimacyTask();
            $this->getFriendIntimacyTaskDic();
        }
        $taskList = array();
        $completeTaskList = array();
        foreach ($this->allFriendIntimacyTaskDic as $taskId => $status) {
            if ($status == TaskData::STATUS_OVER) {
                $completeTaskList[] = $taskId;
            } else {
                $taskData = $this->getTask($taskId);
                if (!is_null($taskData) && $taskData->taskId != 0) {
                    $taskList[] = $taskData;
                }
            }
        }
        return array($taskList, $completeTaskList);
    }

    //每日重置任务
    public function resetFriendIntimacyTask()
    {
        $this->getFriendIntimacyTaskDic();
        //现有的全部任务
        $hasTaskIds = array_keys($this->allFriendIntimacyTaskDic);
        //配置日常任务
        $taskConfigList = $this->getFriendIntimacyConfig();
        //检查 任务是否有新增 删除
        $delTaskIds = array_diff($hasTaskIds, $taskConfigList);
        foreach ($delTaskIds as $taskId) {
            //删除任务
            if (false == $this->delTask($taskId)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::TASK_DEL_ERROR,
                    "[FriendIntimacyTaskManager] del task fail",
                    array(
                        "taskId" => $taskId
                    )
                );
                continue;
            }
        }
        foreach ($taskConfigList as $taskId) {
            if (array_key_exists($taskId, $this->allFriendIntimacyTaskDic)) {
                //重置老任务
                if (false == $this->resetTask($taskId)) {
                    LogMark::getInstance()->markError(
                        GameErrorCode::TASK_RESET_ERROR,
                        "[FriendIntimacyTaskManager] reset task fail",
                        array(
                            "taskId" => $taskId
                        )
                    );
                    continue;
                }
            } elseif (false == $this->createTask($taskId)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::TASK_DAILY_CREATE_ERROR,
                    "[FriendIntimacyTaskManager] daily task create error",
                    array(
                        "taskId" => $taskId
                    )
                );
                continue;
            }
        }
    }

    //关闭任务
    public function closeFriendIntimacyTask()
    {
        //删除现有的全部任务
        $this->getFriendIntimacyTaskDic();
        $hasTaskIds = array_keys($this->allFriendIntimacyTaskDic);
        foreach ($hasTaskIds as $taskId) {
            //删除任务
            if (false == $this->delTask($taskId)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::TASK_DEL_ERROR,
                    "[FriendIntimacyTaskManager] del task fail",
                    array(
                        "taskId" => $taskId
                    )
                );
                continue;
            }
        }
    }

    //查询当前全部的日常任务id
    private function getFriendIntimacyTaskDic()
    {
        if (is_null($this->allFriendIntimacyTaskDic)) {
            $this->allFriendIntimacyTaskDic = array();
        }
        $this->getTitleList(
            DBTableDefine::TABLE_FRIEND_INTIMACY_TASK,
            $this->playerId,
            $this->allFriendIntimacyTaskDic
        );
    }

    private function getFriendIntimacyConfig(): array
    {
        $taskConfigList = $this->getTerm(
            TemplateDefine::TYPE_INIT_PLAYER,
            TemplateInitPlayer::DEFAULT_ID,
            TemplateInitPlayer::FriendIntimacyTaskList
        );
        if (is_null($taskConfigList) || empty($taskConfigList)) {
            LogMark::getInstance()->markError(
                GameErrorCode::TASK_CONFIG_NOT_FOUND,
                "[FriendIntimacyTaskManager] friend intimacy task not found"
            );
            return array();
        }
        return $taskConfigList;
    }

    //--------任务奖励进度-------

    public function openFriendIntimacySchedule()
    {
        $data = new FriendIntimacyRewardData($this->playerId);
        $data->openFriendIntimacyReward();
    }

    public function closeFriendIntimacySchedule()
    {
        $data = new FriendIntimacyRewardData($this->playerId);
        $data->closeFriendIntimacyReward();
    }

    public function updateFriendIntimacyNum(bool $add = true) {
        $data = new FriendIntimacyRewardData($this->playerId);
        $data->searchDB();
        $data->updateFrinedIntimacyNum($add);
    }

    public function resetFriendIntimacySchedule()
    {
        $data = new FriendIntimacyRewardData($this->playerId);
        $data->searchDB();
        $data->resetFriendIntimacyReward();
    }

    public function getFriendIntimacySchedule(): FriendIntimacyRewardData
    {
        $data = new FriendIntimacyRewardData($this->playerId);
        $data->searchDB();
        return $data;
    }

    public function addFriendIntimacyScore(int $addScore)
    {
        if ($addScore <= 0) {
            return;
        }
        $data = new FriendIntimacyRewardData($this->playerId);
        $data->searchDB();
        $data->friendIntimacyRewardScore += $addScore;
        $data->updateDB();
        $this->sendFriendIntimacyScoreMessage($data);
    }

    private function sendFriendIntimacyScoreMessage(FriendIntimacyRewardData $data)
    {
        $message = new GCUpdateFriendIntimacyScore();
        $message->setScore($data->friendIntimacyRewardScore);
        SendMessage::getInstance()->sendClient(PacketId::GC_UpdateFriendIntimacyScore, $message);
    }
}
