<?php

/**
 * 兑换任务
 */

namespace Game\Model\Task\Manager;

use Game\Data\TaskData;


class ExchangeTaskManager extends TaskMangerModelBase
{
    // 获取全部兑换任务
    public function getExchangeTask($ids): array
    {
        $taskList = array();
        $completeTaskList = array();
        $this->setPlayerId($this->playerId);
        foreach ($ids as $taskId) {
            $taskData = $this->getTask($taskId);
            if(is_null($taskData)) {
                continue;
            }
            if ($taskData->taskId != 0) {
                $taskList[] = $taskData;
            }
            if($taskData->status == TaskData::STATUS_OVER) {
                $completeTaskList[] = $taskId;
            }
        }
        return array($taskList, $completeTaskList);
    }

}
