<?php

/**
 * 周登录天数
 */

namespace Game\Model\Task\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Data\TaskData;
use Game\Logic\EventConditionLogic;

class TaskLogicWeekLogin extends TaskLogicBase
{
    use EventConditionLogic;

    public function getDefaultValue(TaskData $taskData, array $param)
    {
        $this->updateTaskSchedule($taskData, 1);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }

    /**
     * @param TaskData $taskData
     * @param array $param
     * param参数  无
     */
    public function updateTask(TaskData $taskData, array $param)
    {
        $this->updateLoginWeekTask($taskData, $param);
    }

    private function updateLoginWeekTask(TaskData $taskData, array $param)
    {
//        // 查询 今日是否登录 没有登录则登录操作
//        /**
//         * @var WelfareModel $welfareModel
//         */
//        $welfareModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WELFARE);
//        $welfareModel->data->searchDB();
//        $day = date("w");
//        if(in_array($day, $welfareModel->data->weekRecord)) {
//            return ;
//        }
//        $welfareModel->data->weekRecord[] = $day;
        $this->updateTaskSchedule($taskData, 1);
        if ($this->checkIsDone($taskData)) {
            $taskData->schedule = $taskData->taskConfig[TemplateTask::Target];
            $taskData->status = TaskData::STATUS_DONE;
        }
    }
}
